/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.views;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.ZoneSelector;
import org.netxms.nxmc.modules.tools.widgets.SearchResult;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class IPAddressSearchView
extends View {
    private final I18n i18n = LocalizationHelper.getI18n(IPAddressSearchView.class);
    private SearchResult searchResultWidget;
    private Button startButton;
    private LabeledText queryEditor;
    private ZoneSelector zoneSelector;
    private boolean zoningEnabled;

    public IPAddressSearchView() {
        super(LocalizationHelper.getI18n(IPAddressSearchView.class).tr("IP Address Search"), ResourceManager.getImageDescriptor((String)"icons/tool-views/search_history.png"), "tools.ip-search", false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        IPAddressSearchView view = (IPAddressSearchView)origin;
        this.zoneSelector.setZoneUIN(view.zoneSelector.getZoneUIN());
        this.queryEditor.setText(view.queryEditor.getText());
        this.searchResultWidget.copyResults(view.searchResultWidget);
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite searchBar = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        searchBar.setLayout((Layout)gridLayout);
        searchBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.zoningEnabled = Registry.getSession().isZoningEnabled();
        if (this.zoningEnabled) {
            this.zoneSelector = new ZoneSelector(searchBar, 0, false);
            this.zoneSelector.setLabel(this.i18n.tr("Zone"));
            this.zoneSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            PreferenceStore settings = PreferenceStore.getInstance();
            try {
                int uin = settings.getAsInteger("IPAddressSelection.ZoneUIN", 0);
                if (Registry.getSession().findZone(uin) != null) {
                    this.zoneSelector.setZoneUIN(uin);
                }
            }
            catch (Exception e) {
                this.zoneSelector.setZoneUIN(0);
            }
        }
        this.queryEditor = new LabeledText(searchBar, 0);
        this.queryEditor.setLabel("Search string");
        this.queryEditor.getTextControl().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.queryEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startButton = new Button(searchBar, 8);
        this.startButton.setImage(SharedIcons.IMG_EXECUTE);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("Start search");
        this.startButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.startButton.setLayoutData((Object)new GridData(4, 1024, false, false));
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.searchResultWidget = new SearchResult((View)this, parent, 0, this.getBaseId());
        this.searchResultWidget.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        this.searchResultWidget.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        this.searchResultWidget.fillLocalPullDown(manager);
    }

    public void setFocus() {
        this.queryEditor.setFocus();
    }

    private void doSearch() {
        int zoneUIN;
        InetAddress ipAddress;
        try {
            ipAddress = InetAddress.getByName(this.queryEditor.getText());
        }
        catch (UnknownHostException e) {
            MessageDialogHelper.openWarning((Shell)this.searchResultWidget.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid IP address!"));
            return;
        }
        int n = zoneUIN = this.zoningEnabled ? this.zoneSelector.getZoneUIN() : 0;
        if (this.zoningEnabled) {
            PreferenceStore settings = PreferenceStore.getInstance();
            settings.set("IPAddressSelection.ZoneUIN", zoneUIN);
        }
        this.startButton.setEnabled(false);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }
}

