/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.WirelessDomain;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.AccessPointsView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.AccessPointFilter;
import org.netxms.nxmc.modules.objects.views.helpers.AccessPointListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.AccessPointListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AccessPointsView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(AccessPointsView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_MAC_ADDRESS = 2;
    public static final int COLUMN_IP_ADDRESS = 3;
    public static final int COLUMN_CONTROLLER = 4;
    public static final int COLUMN_VENDOR = 5;
    public static final int COLUMN_MODEL = 6;
    public static final int COLUMN_SERIAL_NUMBER = 7;
    public static final int COLUMN_STATE = 8;
    public static final int COLUMN_STATUS = 9;
    private SortableTableViewer viewer;
    private Action actionExportToCsv;
    private SessionListener sessionListener;

    public AccessPointsView() {
        super(LocalizationHelper.getI18n(AccessPointsView.class).tr("Access Points"), ResourceManager.getImageDescriptor((String)"icons/object-views/access-points.png"), "objects.access-points", true);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    public boolean isValidForContext(Object context) {
        return context instanceof WirelessDomain;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("MAC Address"), this.i18n.tr("IP Address"), this.i18n.tr("Controller"), this.i18n.tr("Vendor"), this.i18n.tr("Model"), this.i18n.tr("Serial Number"), this.i18n.tr("State"), this.i18n.tr("Status")};
        int[] widths = new int[]{60, 150, 100, 100, 150, 150, 100, 100, 80, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AccessPointListLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new AccessPointListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        AccessPointFilter filter = new AccessPointFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"AccessPointsTable");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
    }

    private void createContextMenu() {
        3 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        if (this.getObject() != null) {
            ArrayList<AbstractObject> list = new ArrayList<AbstractObject>();
            for (AbstractObject o : this.getObject().getAllChildren(33)) {
                list.add(o);
            }
            this.viewer.setInput((Object)list.toArray());
        } else {
            this.viewer.setInput((Object)new AbstractNode[0]);
        }
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.refresh();
        }
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void activate() {
        this.refresh();
        super.activate();
    }
}

