/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logwatch.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logwatch.widgets.LogParserEditor;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserModifyListener;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParserType;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class LogParserConfigurator
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(LogParserConfigurator.class);
    private LogParserType parserType;
    private String configName;
    private String displayName;
    private NXCSession session;
    private LogParserEditor editor;
    private boolean modified = false;
    private String content;
    private Action actionSave;

    public LogParserConfigurator(LogParserType parserType, String configName, String displayName) {
        super(String.format(LocalizationHelper.getI18n(LogParserConfigurator.class).tr("%s Parser"), displayName), ResourceManager.getImageDescriptor((String)"icons/config-views/log-parser.png"), configName, false);
        this.parserType = parserType;
        this.configName = configName;
        this.displayName = displayName;
        this.session = Registry.getSession();
    }

    protected LogParserConfigurator() {
        super(null, null, null, false);
        this.session = Registry.getSession();
    }

    public View cloneView() {
        LogParserConfigurator view = (LogParserConfigurator)super.cloneView();
        view.parserType = this.parserType;
        view.configName = this.configName;
        view.displayName = this.displayName;
        return view;
    }

    public void createContent(Composite parent) {
        this.editor = new LogParserEditor(parent, 0, this.parserType);
        this.editor.addModifyListener((LogParserModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    public void refresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Refresh"), (String)this.i18n.tr("This will destroy all unsaved changes. Are you sure?"))) {
            return;
        }
        this.actionSave.setEnabled(false);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void save() {
        String xml = this.editor.getParserXml();
        this.actionSave.setEnabled(false);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return this.modified;
    }

    private void setModified(boolean b) {
        if (b != this.modified) {
            this.modified = b;
            this.actionSave.setEnabled(this.modified);
        }
    }
}

