/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.views;

import java.text.DateFormat;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.LineChartElement;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractDashboardView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(AbstractDashboardView.class);
    protected DashboardControl dbc;
    private Composite viewArea;
    private ScrolledComposite scroller;
    private boolean narrowScreenMode = false;
    private Action actionExportValues;
    private Action actionSaveAsImage;
    private Action actionNarrowScreenMode;

    public AbstractDashboardView(String name, ImageDescriptor image, String id) {
        super(name, image, id, false);
    }

    protected void createContent(Composite parent) {
        this.viewArea = parent;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.viewArea.setLayout((Layout)layout);
        this.createActions();
    }

    protected void createActions() {
        this.actionExportValues = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportValues.setActionDefinitionId("org.netxms.ui.eclipse.dashboard.commands.export_line_chart_values");
        this.addKeyBinding("M1+F3", (IAction)this.actionExportValues);
        this.actionSaveAsImage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSaveAsImage.setActionDefinitionId("org.netxms.ui.eclipse.dashboard.commands.save_as_image");
        this.addKeyBinding("M1+I", (IAction)this.actionSaveAsImage);
        this.actionNarrowScreenMode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionNarrowScreenMode.setChecked(this.narrowScreenMode);
        this.addKeyBinding("M1+M3+N", (IAction)this.actionNarrowScreenMode);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportValues);
        manager.add((IAction)this.actionSaveAsImage);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportValues);
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionNarrowScreenMode);
        super.fillLocalMenu(manager);
    }

    private void exportLineChartValues() {
        ArrayList<LineChartElement.DataCacheElement> data = new ArrayList<LineChartElement.DataCacheElement>();
        for (ElementWidget w : this.dbc.getElementWidgets()) {
            if (!(w instanceof LineChartElement)) continue;
            for (LineChartElement.DataCacheElement d : ((LineChartElement)w).getDataCache()) {
                data.add(d);
            }
        }
        DateFormat dfDate = DateFormatFactory.getDateFormat();
        DateFormat dfTime = DateFormatFactory.getTimeFormat();
        DateFormat dfDateTime = DateFormatFactory.getDateTimeFormat();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void saveAsImage() {
        JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
        if (executor != null) {
            StringBuilder js = new StringBuilder();
            js.append("RWTUtil_widgetToImage('");
            js.append(WidgetUtil.getId((Widget)this.dbc));
            js.append("', 'div', 'graph.png');");
            executor.execute(js.toString());
        }
    }

    protected void onObjectUpdate(AbstractObject object) {
        super.onObjectUpdate(object);
        this.onObjectChange(object);
    }

    public void refresh() {
        this.rebuildCurrentDashboard();
    }

    public void requestDashboardLayout() {
        if (this.scroller != null) {
            this.updateScroller();
        } else {
            this.viewArea.layout(true, true);
        }
    }

    protected abstract void rebuildCurrentDashboard();

    protected void rebuildDashboard(Dashboard dashboard, AbstractObject dashboardContext) {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        if (this.scroller != null && !dashboard.isScrollable() && !this.narrowScreenMode) {
            this.scroller.dispose();
            this.scroller = null;
        } else if (this.scroller == null && (dashboard.isScrollable() || this.narrowScreenMode)) {
            this.scroller = new ScrolledComposite(this.viewArea, 512);
            this.scroller.setExpandHorizontal(true);
            this.scroller.setExpandVertical(true);
            WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
            this.scroller.setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewArea.layout(true, true);
        }
        this.dbc = new DashboardControl((Composite)(dashboard.isScrollable() || this.narrowScreenMode ? this.scroller : this.viewArea), 0, dashboard, dashboardContext, this, false, this.narrowScreenMode);
        if (dashboard.isScrollable() || this.narrowScreenMode) {
            this.scroller.setContent((Control)this.dbc);
            this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
            this.updateScroller();
        } else {
            this.dbc.setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewArea.layout(true, true);
        }
    }

    private void updateScroller() {
        this.dbc.layout(true, true);
        Rectangle r = this.scroller.getClientArea();
        Point s = this.dbc.computeSize(r.width, -1);
        this.scroller.setMinSize(s);
    }

    static /* synthetic */ NXCSession access$000(AbstractDashboardView x0) {
        return x0.session;
    }
}

