/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.widgets.BarChart;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericComparisonChart;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;

/*
 * Exception performing whole class analysis ignored.
 */
public class BarChart
extends GenericComparisonChart {
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 10;
    private static final int MARGIN_LABELS = 4;

    public BarChart(Chart parent) {
        super(parent);
    }

    protected void createFonts() {
    }

    protected void disposeFonts() {
    }

    protected void render(GC gc) {
        double maxValue;
        double minValue;
        Point size = this.getSize();
        List items = this.chart.getItems();
        if (items.isEmpty() || size.x < 10 || size.y < 20) {
            return;
        }
        List series = this.chart.getDataSeries();
        if (series.isEmpty()) {
            return;
        }
        if (this.chart.getConfiguration().isAutoScale()) {
            maxValue = minValue = ((DataSeries)series.get(0)).getCurrentValue();
            for (DataSeries s : series) {
                if (minValue > s.getCurrentValue()) {
                    minValue = s.getCurrentValue();
                }
                if (!(maxValue < s.getCurrentValue())) continue;
                maxValue = s.getCurrentValue();
            }
            if (minValue >= 0.0) {
                maxValue = BarChart.adjustRange((double)maxValue);
                minValue = 0.0;
                if (maxValue == 0.0) {
                    maxValue = 1.0;
                }
            } else if (maxValue > 0.0) {
                maxValue = BarChart.adjustRange((double)maxValue);
                minValue = -BarChart.adjustRange((double)Math.abs(minValue));
            } else {
                maxValue = 0.0;
                minValue = -BarChart.adjustRange((double)Math.abs(minValue));
            }
        } else {
            minValue = this.chart.getConfiguration().getMinYScaleValue();
            maxValue = this.chart.getConfiguration().getMaxYScaleValue();
        }
        if (this.chart.getConfiguration().isTransposed()) {
            this.renderHorizontal(gc, size, items, series, minValue, maxValue);
        } else {
            this.renderVertical(gc, size, items, series, minValue, maxValue);
        }
    }

    private void renderVertical(GC gc, Point size, List<GraphItem> items, List<DataSeries> series, double minValue, double maxValue) {
        Color axisColor = ThemeEngine.getForegroundColor((String)"Chart.PlotArea");
        gc.setForeground(axisColor);
        double pixelValue = (maxValue - minValue) / (double)(size.y - 20);
        double step = BarChart.getStepMagnitude((double)Math.max(Math.abs(minValue), Math.abs(maxValue)));
        float pointsStep = (float)(step / pixelValue);
        int baseLine = minValue == 0.0 ? size.y - 10 : (maxValue == 0.0 ? 10 : 10 + (int)(maxValue / pixelValue));
        ChartConfiguration config = this.chart.getConfiguration();
        ArrayList<Label> labels = new ArrayList<Label>();
        int labelWidth = 0;
        for (double v = maxValue; v >= minValue; v -= step) {
            Label label = new Label(gc, config.isUseMultipliers() ? DataFormatter.roundDecimalValue((double)v, (double)step, (int)5) : Double.toString(v));
            if (label.size.x > labelWidth) {
                labelWidth = label.size.x;
            }
            labels.add(label);
        }
        int itemWidth = (size.x - 10 - (labelWidth += 4) - 1) / items.size();
        gc.drawLine(5 + labelWidth, baseLine, size.x - 5, baseLine);
        int i = 1;
        int x = 5 + labelWidth + itemWidth;
        while (i < items.size()) {
            gc.drawLine(x, baseLine - 2, x, baseLine + 2);
            ++i;
            x += itemWidth;
        }
        gc.drawLine(5 + labelWidth, 10, 5 + labelWidth, size.y - 10);
        gc.setLineStyle(3);
        Color gridColor = ThemeEngine.getForegroundColor((String)"Chart.Grid");
        float y = 10.0f;
        int i2 = 0;
        while (i2 < labels.size()) {
            Label label = (Label)labels.get(i2);
            gc.setForeground(axisColor);
            gc.drawText(label.text, 5 + labelWidth - label.size.x - 4, (int)y - label.size.y / 2, true);
            if (config.isGridVisible() && (int)y != baseLine) {
                gc.setForeground(gridColor);
                gc.drawLine(5 + labelWidth, (int)y, size.x - 5, (int)y);
            }
            ++i2;
            y += pointsStep;
        }
        gc.setLineStyle(1);
        if (itemWidth >= 4) {
            if (config.isTranslucent()) {
                gc.setAlpha(127);
            }
            int margin = Math.max(Math.min(10, itemWidth / 10), 1);
            int i3 = 0;
            int x2 = 5 + labelWidth;
            while (i3 < items.size()) {
                double value = series.get(i3).getCurrentValue();
                if (value != 0.0) {
                    int color = items.get(i3).getColor();
                    gc.setBackground(this.chart.getColorCache().create(color == -1 ? this.chart.getPaletteEntry(i3).getRGBObject() : ColorConverter.rgbFromInt((int)color)));
                    int h = (int)Math.abs(value / pixelValue);
                    gc.fillRectangle(x2 + margin, value > 0.0 ? baseLine - h : baseLine, itemWidth - margin * 2, h);
                }
                ++i3;
                x2 += itemWidth;
            }
        }
    }

    private void renderHorizontal(GC gc, Point size, List<GraphItem> items, List<DataSeries> series, double minValue, double maxValue) {
        Color axisColor = ThemeEngine.getForegroundColor((String)"Chart.PlotArea");
        gc.setForeground(axisColor);
        double pixelValue = (maxValue - minValue) / (double)(size.x - 10);
        double step = BarChart.getStepMagnitude((double)Math.max(Math.abs(minValue), Math.abs(maxValue)));
        float pointsStep = (float)(step / pixelValue);
        int baseLine = minValue == 0.0 ? 5 : (maxValue == 0.0 ? size.x - 5 : 5 + (int)(minValue / pixelValue));
        int labelHeight = gc.textExtent((String)"000").y + 4;
        ChartConfiguration config = this.chart.getConfiguration();
        ArrayList<Label> labels = new ArrayList<Label>();
        for (double v = minValue; v <= maxValue; v += step) {
            Label label = new Label(gc, config.isUseMultipliers() ? DataFormatter.roundDecimalValue((double)v, (double)step, (int)5) : Double.toString(v));
            labels.add(label);
        }
        int itemHeight = (size.y - 20 - labelHeight - 1) / items.size();
        gc.drawLine(baseLine, 10, baseLine, size.y - 10 - labelHeight);
        int i = 1;
        int y = 10 + itemHeight;
        while (i < items.size()) {
            gc.drawLine(baseLine - 2, y, baseLine + 2, y);
            ++i;
            y += itemHeight;
        }
        gc.drawLine(5, size.y - 10 - labelHeight, size.x - 5, size.y - 10 - labelHeight);
        gc.setLineStyle(3);
        Color gridColor = ThemeEngine.getForegroundColor((String)"Chart.Grid");
        float x = 5.0f;
        int i2 = 0;
        while (i2 < labels.size()) {
            Label label = (Label)labels.get(i2);
            gc.setForeground(axisColor);
            gc.drawText(label.text, (int)x - label.size.x / 2, size.y - 10 - labelHeight, true);
            if (config.isGridVisible() && (int)x != baseLine) {
                gc.setForeground(gridColor);
                gc.drawLine((int)x, 10, (int)x, size.y - 10 - labelHeight);
            }
            ++i2;
            x += pointsStep;
        }
        gc.setLineStyle(1);
        if (itemHeight >= 4) {
            if (config.isTranslucent()) {
                gc.setAlpha(127);
            }
            int margin = Math.max(Math.min(10, itemHeight / 10), 1);
            int i3 = 0;
            int y2 = 10;
            while (i3 < items.size()) {
                double value = series.get(i3).getCurrentValue();
                if (value != 0.0) {
                    int color = items.get(i3).getColor();
                    gc.setBackground(this.chart.getColorCache().create(color == -1 ? this.chart.getPaletteEntry(i3).getRGBObject() : ColorConverter.rgbFromInt((int)color)));
                    int w = (int)Math.abs(value / pixelValue);
                    gc.fillRectangle((value < 0.0 ? baseLine - w : baseLine) + 1, y2 + margin, w, itemHeight - margin * 2);
                }
                ++i3;
                y2 += itemHeight;
            }
        }
    }

    private static double adjustRange(double upper) {
        double adjustedUpper = upper;
        for (double d = 1.0E-5; d < 1.0E19; d *= 10.0) {
            if (!(upper > d) || !(upper <= d * 10.0)) continue;
            adjustedUpper -= adjustedUpper % d;
            adjustedUpper += d;
            break;
        }
        return adjustedUpper;
    }

    private static double getStepMagnitude(double maxValue) {
        double d;
        for (d = 1.0E-5; !(!(d < 1.0E19) || maxValue > d && maxValue <= d * 10.0); d *= 10.0) {
        }
        return d;
    }
}

