/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.widgets;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.Pair;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.objects.GenericObject;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.widgets.AssetPropertyEditor;
import org.netxms.nxmc.modules.logwatch.widgets.helpers.LogParser;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.IPAddressValidator;
import org.netxms.nxmc.tools.MacAddressValidator;
import org.netxms.nxmc.tools.NumericTextFieldValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetFactory;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class AssetPropertyEditor
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(AssetPropertyEditor.class);
    private final I18n i18n = LocalizationHelper.getI18n(AssetPropertyEditor.class);
    private List<Pair<String, String>> enumValues;
    private AssetAttribute attribute;
    private Control editorControl;
    private LabeledText text;
    private LabeledCombo combo;
    private ObjectSelector objectSelector;
    private DateTime dateSelector;

    public AssetPropertyEditor(Composite parent, int style, AssetAttribute attribute) {
        super(parent, style);
        this.attribute = attribute;
        this.setLayout((Layout)new FillLayout());
        Object label = attribute.getEffectiveDisplayName();
        if (attribute.isMandatory()) {
            label = (String)label + " *";
        }
        switch (2.$SwitchMap$org$netxms$client$constants$AMDataType[attribute.getDataType().ordinal()]) {
            case 1: {
                this.combo = new LabeledCombo((Composite)this, 0);
                this.combo.setLabel((String)label);
                this.combo.add("Yes");
                this.combo.add("No");
                this.editorControl = this.combo.getControl();
                break;
            }
            case 2: {
                this.combo = new LabeledCombo((Composite)this, 0);
                this.combo.setLabel((String)label);
                this.enumValues = new ArrayList(attribute.getEnumValues().size());
                for (Map.Entry entry : attribute.getEnumValues().entrySet()) {
                    this.enumValues.add(new Pair((Object)(((String)entry.getValue()).isBlank() ? (String)entry.getKey() : (String)entry.getValue()), (Object)((String)entry.getKey())));
                }
                this.enumValues.sort((a1, a2) -> ((String)a1.getFirst()).compareToIgnoreCase((String)a2.getFirst()));
                for (Pair pair : this.enumValues) {
                    this.combo.add((String)pair.getFirst());
                }
                this.editorControl = this.combo.getControl();
                break;
            }
            case 3: {
                this.objectSelector = new ObjectSelector((Composite)this, 0, !attribute.isMandatory());
                this.objectSelector.setLabel((String)label);
                this.objectSelector.setObjectClass(GenericObject.class);
                this.editorControl = this.objectSelector;
                break;
            }
            case 4: {
                1 factory = new /* Unavailable Anonymous Inner Class!! */;
                this.dateSelector = (DateTime)WidgetHelper.createLabeledControl((Composite)this, (int)2084, (WidgetFactory)factory, (String)label, null);
                this.editorControl = this.dateSelector;
                break;
            }
            default: {
                this.text = new LabeledText((Composite)this, 0);
                this.text.setLabel((String)label);
                this.editorControl = this.text.getControl();
            }
        }
    }

    public void setValue(String value) {
        switch (2.$SwitchMap$org$netxms$client$constants$AMDataType[this.attribute.getDataType().ordinal()]) {
            case 1: {
                this.combo.select(LogParser.stringToBoolean((String)value) ? 0 : 1);
                break;
            }
            case 2: {
                Pair element;
                if (value == null) break;
                int currentIndex = 0;
                Iterator iterator = this.enumValues.iterator();
                while (iterator.hasNext() && !value.equals((element = (Pair)iterator.next()).getSecond())) {
                    ++currentIndex;
                }
                this.combo.select(currentIndex);
                break;
            }
            case 3: {
                if (value != null) {
                    int objectId = 0;
                    try {
                        objectId = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        logger.error("Cannot parse object ID", (Throwable)e);
                    }
                    this.objectSelector.setObjectId((long)objectId);
                    break;
                }
                this.objectSelector.setObjectId(0L);
                break;
            }
            case 4: {
                if (value == null) break;
                Calendar c = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                try {
                    c.setTime(sdf.parse(value));
                }
                catch (ParseException e) {
                    logger.error("Cannot parse date", (Throwable)e);
                }
                this.dateSelector.setDate(c.get(1), c.get(2), c.get(5));
                break;
            }
            default: {
                this.text.setText(value != null ? value : "");
            }
        }
    }

    public boolean validateInput() {
        switch (2.$SwitchMap$org$netxms$client$constants$AMDataType[this.attribute.getDataType().ordinal()]) {
            case 1: {
                if (this.combo.getSelectionIndex() == -1 && this.attribute.isMandatory()) {
                    this.combo.setErrorMessage(this.i18n.tr("This property is mandatory"));
                }
                this.combo.setErrorMessage(null);
                return true;
            }
            case 2: {
                if (this.combo.getSelectionIndex() == -1 && this.attribute.isMandatory()) {
                    this.combo.setErrorMessage(this.i18n.tr("This property is mandatory"));
                }
                this.combo.setErrorMessage(null);
                return true;
            }
            case 5: {
                if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
                    this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                return WidgetHelper.validateTextInput((LabeledText)this.text, (TextFieldValidator)new IPAddressValidator(true));
            }
            case 6: {
                if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
                    this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                return WidgetHelper.validateTextInput((LabeledText)this.text, (TextFieldValidator)new MacAddressValidator(true));
            }
            case 7: {
                if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
                    this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                if (this.text.getText().isBlank()) {
                    this.text.setErrorMessage(null);
                    return true;
                }
                return WidgetHelper.validateTextInput((LabeledText)this.text, (TextFieldValidator)new NumericTextFieldValidator((double)this.attribute.getRangeMin(), (double)this.attribute.getRangeMax()));
            }
            case 8: {
                if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
                    this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                if (this.text.getText().isBlank()) {
                    this.text.setErrorMessage(null);
                    return true;
                }
                return WidgetHelper.validateTextInput((LabeledText)this.text, (TextFieldValidator)new NumericTextFieldValidator((long)this.attribute.getRangeMin(), (long)this.attribute.getRangeMax()));
            }
            case 3: {
                if (this.attribute.isMandatory() && this.objectSelector.getObjectId() == 0L) {
                    this.objectSelector.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                this.objectSelector.setErrorMessage(null);
                return true;
            }
            case 9: {
                if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
                    this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                if (this.attribute.getRangeMax() != 0 && this.attribute.getRangeMin() != 0) {
                    String value = this.text.getText().trim();
                    if (value.isEmpty()) {
                        this.text.setErrorMessage(null);
                        return true;
                    }
                    if (value.length() < this.attribute.getRangeMin()) {
                        this.text.setErrorMessage(this.i18n.tr("Value is too short"));
                        return false;
                    }
                    if (value.length() > this.attribute.getRangeMax()) {
                        this.text.setErrorMessage(this.i18n.tr("Value is too long"));
                        return false;
                    }
                }
                this.text.setErrorMessage(null);
                return true;
            }
            case 10: {
                if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
                    this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
                    return false;
                }
                if (this.text.getText().isBlank()) {
                    this.text.setErrorMessage(null);
                    return true;
                }
                try {
                    UUID.fromString(this.text.getText().trim());
                }
                catch (IllegalArgumentException e) {
                    this.text.setErrorMessage(this.i18n.tr("Invalid UUID"));
                    return false;
                }
                this.text.setErrorMessage(null);
                return true;
            }
            case 4: {
                return true;
            }
        }
        if (this.attribute.isMandatory() && this.text.getText().isBlank()) {
            this.text.setErrorMessage(this.i18n.tr("This property is mandatory"));
            return false;
        }
        this.text.setErrorMessage(null);
        return true;
    }

    public String getValue() {
        switch (2.$SwitchMap$org$netxms$client$constants$AMDataType[this.attribute.getDataType().ordinal()]) {
            case 1: {
                if (this.combo.getSelectionIndex() == -1) {
                    return "";
                }
                return this.combo.getSelectionIndex() == 0 ? "true" : "false";
            }
            case 2: {
                if (this.combo.getSelectionIndex() == -1) {
                    return "";
                }
                return (String)((Pair)this.enumValues.get(this.combo.getSelectionIndex())).getSecond();
            }
            case 3: {
                return this.objectSelector.getObjectId() == 0L ? "" : Long.toString(this.objectSelector.getObjectId());
            }
            case 4: {
                return Integer.toString(this.dateSelector.getYear() * 10000 + (this.dateSelector.getMonth() + 1) * 100 + this.dateSelector.getDay());
            }
        }
        return this.text.getText().trim();
    }

    public Control getEditorControl() {
        return this.editorControl;
    }

    public AssetAttribute getAttribute() {
        return this.attribute;
    }
}

