/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AutoBind
extends PropertyPage {
    private AutoBindObject object;
    private Button checkboxEnableBind;
    private Button checkboxEnableUnbind;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialAutoBindFilter;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AutoBindObject)this.getElement().getAdapter(AutoBindObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        this.initialBind = this.object.isAutoBindEnabled();
        this.initialUnbind = this.object.isAutoUnbindEnabled();
        this.initialAutoBindFilter = this.object.getAutoBindFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableBind = new Button(dialogArea, 32);
        if (this.object instanceof Cluster) {
            this.checkboxEnableBind.setText("Automatically add nodes selected by filter to this cluster");
        } else if (this.object instanceof Container) {
            Messages.get();
            this.checkboxEnableBind.setText(Messages.AutoBind_AutoBind);
        }
        this.checkboxEnableBind.setSelection(this.object.isAutoBindEnabled());
        this.checkboxEnableBind.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (AutoBind.this.checkboxEnableBind.getSelection()) {
                    AutoBind.this.filterSource.setEnabled(true);
                    AutoBind.this.filterSource.setFocus();
                    AutoBind.this.checkboxEnableUnbind.setEnabled(true);
                } else {
                    AutoBind.this.filterSource.setEnabled(false);
                    AutoBind.this.checkboxEnableUnbind.setEnabled(false);
                }
            }
        });
        this.checkboxEnableUnbind = new Button(dialogArea, 32);
        if (this.object instanceof Cluster) {
            this.checkboxEnableUnbind.setText("Automatically remove nodes from this cluster when they no longer passes filter");
        } else if (this.object instanceof Container) {
            Messages.get();
            this.checkboxEnableUnbind.setText(Messages.AutoBind_AUtoUnbind);
        }
        this.checkboxEnableUnbind.setSelection(this.object.isAutoUnbindEnabled());
        this.checkboxEnableUnbind.setEnabled(this.object.isAutoBindEnabled());
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.AutoBind_Script);
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\tnode being tested (null if object is not a node).\r\n\t$object\tobject being tested.\r\n\t$container\tthis container object.\r\n\r\nReturn value: true to bind node to this container, false to unbind, null to make no changes.");
        this.filterSource.setText(this.object.getAutoBindFilter());
        this.filterSource.setEnabled(this.object.isAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        final boolean apply = this.checkboxEnableBind.getSelection();
        final boolean remove = this.checkboxEnableUnbind.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(((GenericObject)this.object).getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        int flags = this.object.getAutoBindFlags();
        flags = apply ? flags | 1 : flags & 0xFFFFFFFE;
        flags = remove ? flags | 2 : flags & 0xFFFFFFFD;
        md.setAutoBindFlags(Integer.valueOf(flags));
        Messages.get();
        new ConsoleJob(Messages.AutoBind_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                AutoBind.this.initialBind = apply;
                AutoBind.this.initialUnbind = remove;
                AutoBind.this.initialAutoBindFilter = md.getAutoBindFilter();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AutoBind.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AutoBind_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

