/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataType;
import org.netxms.client.snmp.SnmpObjectId;

public class ColumnDefinition {
    public static final int TCF_DATA_TYPE_MASK = 15;
    public static final int TCF_AGGREGATE_FUNCTION_MASK = 112;
    public static final int TCF_INSTANCE_COLUMN = 256;
    public static final int TCF_SNMP_HEX_STRING = 1024;
    private String name;
    private String displayName;
    private int flags;
    private SnmpObjectId snmpObjectId;

    public ColumnDefinition() {
        this.name = "";
        this.displayName = "";
        this.flags = 0;
        this.setDataType(DataType.STRING);
        this.snmpObjectId = null;
    }

    public ColumnDefinition(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.flags = 0;
        this.setDataType(DataType.STRING);
        this.snmpObjectId = null;
    }

    public ColumnDefinition(ColumnDefinition src) {
        this.name = src.name;
        this.displayName = src.displayName;
        this.flags = src.flags;
        this.snmpObjectId = src.snmpObjectId;
    }

    protected ColumnDefinition(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.flags = msg.getFieldAsInt32(baseId + 1L);
        long[] oid = msg.getFieldAsUInt32Array(baseId + 2L);
        this.snmpObjectId = oid != null ? new SnmpObjectId(oid) : null;
        this.displayName = msg.getFieldAsString(baseId + 3L);
        if (this.displayName == null || this.displayName.length() == 0) {
            this.displayName = this.name;
        }
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.name);
        msg.setFieldInt16(baseId + 1L, this.flags);
        if (this.snmpObjectId != null) {
            this.snmpObjectId.setNXCPVariable(msg, baseId + 2L);
        }
        msg.setField(baseId + 3L, this.displayName);
    }

    public DataType getDataType() {
        return DataType.getByValue(this.flags & 0xF);
    }

    public void setDataType(DataType dataType) {
        this.flags = this.flags & 0xFFFFFFF0 | dataType.getValue() & 0xF;
    }

    public int getAggregationFunction() {
        return (this.flags & 0x70) >> 4;
    }

    public void setAggregationFunction(int function) {
        this.flags = this.flags & 0xFFFFFF8F | function << 4 & 0x70;
    }

    public SnmpObjectId getSnmpObjectId() {
        return this.snmpObjectId;
    }

    public void setSnmpObjectId(SnmpObjectId snmpObjectId) {
        this.snmpObjectId = snmpObjectId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isInstanceColumn() {
        return (this.flags & 0x100) != 0;
    }

    public void setInstanceColumn(boolean isInstance) {
        this.flags = isInstance ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public boolean isConvertSnmpStringToHex() {
        return (this.flags & 0x400) != 0;
    }

    public void setConvertSnmpStringToHex(boolean convert) {
        this.flags = convert ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public void setName(String name) {
        this.name = name;
    }
}

