/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericGauge;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DialGauge
extends GenericGauge {
    private static final int NEEDLE_PIN_RADIUS = 8;
    private static final int SCALE_OFFSET = 18;
    private static final int SCALE_WIDTH = 3;
    private static final int COLOR_RING_OFFSET = 2;
    private static final int COLOR_RING_WIDTH = 5;
    private static final int LABEL_TOP_MARGIN = 6;
    private Font[] scaleFonts = null;
    private Font[] valueFonts = null;

    public DialGauge(Chart parent) {
        super(parent);
    }

    @Override
    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        int i = 0;
        while (i < this.scaleFonts.length) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
            ++i;
        }
        this.valueFonts = new Font[16];
        i = 0;
        while (i < this.valueFonts.length) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 1);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        int i;
        if (this.scaleFonts != null) {
            i = 0;
            while (i < this.scaleFonts.length) {
                this.scaleFonts[i].dispose();
                ++i;
            }
        }
        if (this.valueFonts != null) {
            i = 0;
            while (i < this.valueFonts.length) {
                this.valueFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void renderElement(GC gc, ChartConfiguration configuration, Object renderData, GraphItem dci, DataSeries data, int x, int y, int w, int h, int index) {
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        int heightAdjustment = rect.height / 6;
        rect.height += heightAdjustment;
        if (configuration.areLabelsVisible() && !configuration.areLabelsInside()) {
            rect.height -= gc.textExtent((String)"MMM").y + 6;
        }
        if (rect.height > rect.width) {
            rect.y += (rect.height - rect.width) / 2;
            rect.height = rect.width;
        } else {
            rect.x += (rect.width - rect.height) / 2;
            rect.width = rect.height;
        }
        double maxValue = configuration.getMaxYScaleValue();
        double minValue = configuration.getMinYScaleValue();
        double angleValue = (maxValue - minValue) / 270.0;
        int outerRadius = (rect.width + 1) / 2;
        int scaleOuterOffset = rect.width / 2 * 18 / 100;
        int scaleCenterOffset = rect.width / 2 * 21 / 100;
        int scaleInnerOffset = rect.width / 2 * 28 / 100;
        int cx = rect.x + rect.width / 2 + 1;
        int cy = rect.y + rect.height / 2 + 1;
        gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.fillArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        GaugeColorMode colorMode = GaugeColorMode.getByValue(configuration.getGaugeColorMode());
        switch (colorMode) {
            case CUSTOM: {
                this.drawZone(gc, rect, 225.0, minValue, maxValue, angleValue, this.chart.getPaletteEntry(0).getRGBObject());
                break;
            }
            case DATA_SOURCE: {
                this.drawZone(gc, rect, 225.0, minValue, maxValue, angleValue, this.getDataSourceColor(dci, index));
                break;
            }
            case THRESHOLD: {
                this.drawZone(gc, rect, 225.0, minValue, maxValue, angleValue, StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()).getRGB());
                break;
            }
            case ZONE: {
                double startAngle = 225.0;
                startAngle = this.drawZone(gc, rect, startAngle, minValue, configuration.getLeftRedZone(), angleValue, RED_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getLeftRedZone(), configuration.getLeftYellowZone(), angleValue, YELLOW_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getLeftYellowZone(), configuration.getRightYellowZone(), angleValue, GREEN_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getRightYellowZone(), configuration.getRightRedZone(), angleValue, YELLOW_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getRightRedZone(), maxValue, angleValue, RED_ZONE_COLOR);
                break;
            }
        }
        gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.setForeground(this.chart.getColorFromPreferences("Chart.Axis.Y.Color"));
        gc.fillArc(rect.x + scaleInnerOffset, rect.y + scaleInnerOffset, rect.width - scaleInnerOffset * 2, rect.height - scaleInnerOffset * 2, 0, 360);
        Color scaleColor = this.chart.getColorFromPreferences("Chart.Colors.DialScale");
        gc.setForeground(scaleColor);
        int textOffset = rect.width / 2 * 18 / 200;
        double arcLength = (double)(outerRadius - scaleOuterOffset) * 4.71238898038469;
        int step = arcLength >= 200.0 ? 27 : 54;
        double valueStep = Math.abs((maxValue - minValue) / (double)(arcLength >= 200.0 ? 10 : 20));
        int textWidth = (int)(Math.sqrt((outerRadius - scaleOuterOffset) * (outerRadius - scaleOuterOffset) / 2) * 0.7);
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"900MM", (int)textWidth, (int)(outerRadius - scaleOuterOffset));
        gc.setFont(markFont);
        gc.setLineWidth(1);
        int i = 225;
        while (i >= -45) {
            if (configuration.isGridVisible()) {
                gc.setForeground(scaleColor);
                Point l1 = this.positionOnArc(cx, cy, outerRadius - scaleOuterOffset, i);
                Point l2 = this.positionOnArc(cx, cy, outerRadius - scaleCenterOffset, i);
                gc.drawLine(l1.x, l1.y, l2.x, l2.y);
            }
            double angle = (double)(225 - i) * angleValue + minValue;
            String value = DataFormatter.roundDecimalValue((double)angle, (double)valueStep, (int)5);
            Point t = this.positionOnArc(cx, cy, outerRadius - textOffset, i);
            Point ext = gc.textExtent(value, 1);
            gc.drawText(value, t.x - ext.x / 2, t.y - ext.y / 2, 1);
            i -= step;
        }
        gc.drawArc(rect.x + scaleCenterOffset, rect.y + scaleCenterOffset, rect.width - scaleCenterOffset * 2, rect.height - scaleCenterOffset * 2, -45, 270);
        double dciValue = data.getCurrentValue();
        if (dciValue < minValue) {
            dciValue = minValue;
        }
        if (dciValue > maxValue) {
            dciValue = maxValue;
        }
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)(String.valueOf(Integer.toString((int)maxValue)) + ".00"), (int)(outerRadius - scaleInnerOffset - 6), (int)(rect.height / 8)));
        switch (colorMode) {
            case CUSTOM: {
                gc.setForeground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                break;
            }
            case DATA_SOURCE: {
                gc.setForeground(this.chart.getColorCache().create(this.getDataSourceColor(dci, index)));
                break;
            }
            case THRESHOLD: {
                gc.setForeground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                break;
            }
            case ZONE: {
                if (dciValue <= configuration.getLeftRedZone() || dciValue >= configuration.getRightRedZone()) {
                    gc.setForeground(this.chart.getColorCache().create(RED_ZONE_COLOR));
                    break;
                }
                if (dciValue <= configuration.getLeftYellowZone() || dciValue >= configuration.getRightYellowZone()) {
                    gc.setForeground(this.chart.getColorCache().create(YELLOW_ZONE_COLOR));
                    break;
                }
                gc.setForeground(this.chart.getColorCache().create(GREEN_ZONE_COLOR));
                break;
            }
            default: {
                gc.setForeground(scaleColor);
            }
        }
        String value = this.getValueAsDisplayString(dci, data);
        Point ext = gc.textExtent(value, 1);
        gc.drawText(value, cx - ext.x / 2, cy + rect.height / 4 + 3, true);
        gc.setBackground(gc.getForeground());
        int angle = (int)(225.0 - (dciValue - minValue) / angleValue);
        Point needleEnd = this.positionOnArc(cx, cy, outerRadius - scaleInnerOffset, angle);
        Point np1 = this.positionOnArc(cx, cy, 4, angle - 90);
        Point np2 = this.positionOnArc(cx, cy, 4, angle + 90);
        gc.fillPolygon(new int[]{np1.x, np1.y, needleEnd.x, needleEnd.y, np2.x, np2.y});
        gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.DialNeedlePin"));
        gc.fillArc(cx - 8, cy - 8, 15, 15, 0, 360);
        gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.fillArc(cx - 4, cy - 4, 7, 7, 0, 360);
        if (configuration.areLabelsVisible()) {
            gc.setFont(configuration.areLabelsInside() ? WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"XXXXXXXXXXXXXXXXXXXXXXXX", (int)(rect.width - scaleInnerOffset * 2 - 6), (int)(rect.height / 8)) : null);
            ext = gc.textExtent(dci.getDescription(), 1);
            gc.setForeground(this.chart.getColorFromPreferences("Chart.Colors.Legend"));
            if (configuration.areLabelsInside()) {
                gc.drawText(dci.getDescription(), rect.x + (rect.width - ext.x) / 2, rect.y + scaleCenterOffset / 2 + rect.height / 4, true);
            } else {
                gc.drawText(dci.getDescription(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 6 - heightAdjustment, true);
            }
        }
    }

    private double drawZone(GC gc, Rectangle rect, double startAngle, double minValue, double maxValue, double angleValue, RGB color) {
        if (minValue >= maxValue) {
            return startAngle;
        }
        double angle = (maxValue - minValue) / angleValue;
        if (angle <= 0.0) {
            return startAngle;
        }
        int offset = rect.width / 2 * 23 / 100;
        gc.setBackground(this.chart.getColorCache().create(color));
        gc.fillArc(rect.x + offset, rect.y + offset, rect.width - offset * 2, rect.height - offset * 2, (int)Math.ceil(startAngle), (int)(-Math.ceil(angle)));
        return startAngle - angle;
    }

    private Point positionOnArc(int cx, int cy, int radius, int angle) {
        return new Point((int)((double)radius * Math.cos(Math.toRadians(angle)) + (double)cx), (int)((double)radius * -Math.sin(Math.toRadians(angle)) + (double)cy));
    }

    @Override
    protected Point getMinElementSize() {
        return new Point(40, 40);
    }
}

