/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets.ansi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsoleViewer;
import org.netxms.ui.eclipse.widgets.ansi.AnsiConsoleAttributes;
import org.netxms.ui.eclipse.widgets.ansi.AnsiConsoleColorPalette;

public class AnsiIOConsoleViewer
extends IOConsoleViewer {
    private static final Pattern pattern = Pattern.compile("\\x1b\\[[^\\x40-\\x7e]*.");
    private static final char ESCAPE_SGR = 'm';
    private AnsiConsoleAttributes lastAttributes = new AnsiConsoleAttributes();
    private AnsiConsoleAttributes currentAttributes = new AnsiConsoleAttributes();
    private int lastRangeEnd = 0;

    public AnsiIOConsoleViewer(Composite parent, IOConsole console) {
        super(parent, (TextConsole)console);
    }

    private boolean interpretCommand(List<Integer> nCommands) {
        boolean result = false;
        Iterator<Integer> iter = nCommands.iterator();
        block23: while (iter.hasNext()) {
            int nCmd = iter.next();
            switch (nCmd) {
                case 0: {
                    this.currentAttributes.reset();
                    break;
                }
                case 1: {
                    this.currentAttributes.bold = true;
                    break;
                }
                case 2: {
                    this.currentAttributes.bold = false;
                    break;
                }
                case 22: {
                    this.currentAttributes.bold = false;
                    break;
                }
                case 3: {
                    this.currentAttributes.italic = true;
                    break;
                }
                case 23: {
                    this.currentAttributes.italic = false;
                    break;
                }
                case 4: {
                    this.currentAttributes.underline = 0;
                    break;
                }
                case 21: {
                    this.currentAttributes.underline = 1;
                    break;
                }
                case 24: {
                    this.currentAttributes.underline = -1;
                    break;
                }
                case 9: {
                    this.currentAttributes.strike = true;
                    break;
                }
                case 29: {
                    this.currentAttributes.strike = false;
                    break;
                }
                case 7: {
                    this.currentAttributes.invert = true;
                    break;
                }
                case 27: {
                    this.currentAttributes.invert = false;
                    break;
                }
                case 8: {
                    this.currentAttributes.conceal = true;
                    break;
                }
                case 28: {
                    this.currentAttributes.conceal = false;
                    break;
                }
                case 51: {
                    this.currentAttributes.framed = true;
                    break;
                }
                case 54: {
                    this.currentAttributes.framed = false;
                    break;
                }
                case 39: {
                    this.currentAttributes.currentFgColor = null;
                    break;
                }
                case 49: {
                    this.currentAttributes.currentBgColor = null;
                    break;
                }
                case 38: 
                case 48: {
                    int color;
                    int nMustBe5;
                    int n = nMustBe5 = iter.hasNext() ? iter.next() : -1;
                    if (nMustBe5 != 5) continue block23;
                    int n2 = color = iter.hasNext() ? iter.next() : -1;
                    if (color < 0 || color >= 256) continue block23;
                    if (nCmd == 38) {
                        this.currentAttributes.currentFgColor = color;
                        break;
                    }
                    this.currentAttributes.currentBgColor = color;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    if (nCmd >= 30 && nCmd <= 37) {
                        this.currentAttributes.currentFgColor = nCmd - 30;
                        break;
                    }
                    if (nCmd >= 40 && nCmd <= 47) {
                        this.currentAttributes.currentBgColor = nCmd - 40;
                        break;
                    }
                    if (nCmd >= 90 && nCmd <= 97) {
                        this.currentAttributes.currentFgColor = nCmd - 90 + 8;
                        break;
                    }
                    if (nCmd < 100 || nCmd > 107) continue block23;
                    this.currentAttributes.currentBgColor = nCmd - 100 + 8;
                }
            }
        }
        return result;
    }

    private void addRange(List<StyleRange> ranges, int start, int length, Color foreground, boolean isCode) {
        StyleRange range = new StyleRange(start, length, foreground, null);
        AnsiConsoleAttributes.updateRangeStyle(range, this.lastAttributes);
        if (isCode) {
            range.metrics = new GlyphMetrics(0, 0, 0);
        }
        ranges.add(range);
        this.lastRangeEnd += range.length;
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyleRange defStyle;
        if (event == null || event.lineText == null || event.lineText.length() == 0) {
            return;
        }
        if (event.styles != null && event.styles.length > 0) {
            defStyle = (StyleRange)event.styles[0].clone();
            if (defStyle.background == null) {
                defStyle.background = AnsiConsoleAttributes.getDefaultBackgroundColor();
            }
        } else {
            defStyle = new StyleRange(1, this.lastRangeEnd, new Color(null, AnsiConsoleColorPalette.getColor(0)), new Color(null, AnsiConsoleColorPalette.getColor(15)), 0);
        }
        this.lastRangeEnd = 0;
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        String currentText = event.lineText;
        Matcher matcher = pattern.matcher(currentText);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String theEscape = currentText.substring(matcher.start() + 2, matcher.end() - 1);
            char code = currentText.charAt(matcher.end() - 1);
            if (code == 'm') {
                ArrayList<Integer> nCommands = new ArrayList<Integer>();
                String[] stringArray = theEscape.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cmd = stringArray[n2];
                    int nCmd = AnsiIOConsoleViewer.tryParseInteger(cmd);
                    if (nCmd != -1) {
                        nCommands.add(nCmd);
                    }
                    ++n2;
                }
                if (nCommands.isEmpty()) {
                    nCommands.add(0);
                }
                this.interpretCommand(nCommands);
            }
            if (this.lastRangeEnd != start) {
                this.addRange(ranges, event.lineOffset + this.lastRangeEnd, start - this.lastRangeEnd, defStyle.foreground, false);
            }
            this.lastAttributes = this.currentAttributes.clone();
            this.addRange(ranges, event.lineOffset + start, end - start, defStyle.foreground, true);
        }
        if (this.lastRangeEnd != currentText.length()) {
            this.addRange(ranges, event.lineOffset + this.lastRangeEnd, currentText.length() - this.lastRangeEnd, defStyle.foreground, false);
        }
        this.lastAttributes = this.currentAttributes.clone();
        if (!ranges.isEmpty()) {
            event.styles = ranges.toArray(new StyleRange[ranges.size()]);
        }
    }

    private static int tryParseInteger(String text) {
        if ("".equals(text)) {
            return -1;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

