/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.snmp.dialogs.MibWalkDialog;
import org.netxms.nxmc.modules.snmp.shared.MibCache;
import org.netxms.nxmc.modules.snmp.widgets.MibBrowser;
import org.netxms.nxmc.modules.snmp.widgets.MibObjectDetails;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MibSelectionDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(MibSelectionDialog.class);
    private long nodeId = 0L;
    private MibBrowser mibTree;
    private Text oid;
    private MibObjectDetails details;
    private MibObject selectedObject;
    private SnmpObjectId selectedObjectId;
    private SnmpObjectId initialSelection;
    private boolean updateObjectId = true;

    public MibSelectionDialog(Shell parentShell, SnmpObjectId initialSelection, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initialSelection = initialSelection;
        this.nodeId = nodeId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select MIB Object"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsPoint("MibSelectionDialog.size", 400, 250));
    }

    protected Control createDialogArea(Composite parent) {
        MibObject object;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = this.nodeId != 0L ? 3 : 2;
        dialogArea.setLayout((Layout)layout);
        Composite mibTreeGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        mibTreeGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        mibTreeGroup.setLayoutData((Object)gd);
        Label label = new Label(mibTreeGroup, 0);
        label.setText(this.i18n.tr("MIB tree"));
        this.mibTree = new MibBrowser(mibTreeGroup, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.widthHint = 500;
        gd.heightHint = 250;
        this.mibTree.setLayoutData((Object)gd);
        this.mibTree.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.oid = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)500, (String)this.i18n.tr("Object identifier (OID)"), (String)"", (Object)"WidgetHelper::default_layout_data");
        this.oid.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.nodeId != 0L) {
            Button button = new Button(dialogArea, 8);
            button.setText(this.i18n.tr("&Walk..."));
            gd = new GridData();
            gd.widthHint = 90;
            gd.verticalAlignment = 1024;
            button.setLayoutData((Object)gd);
            button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.details = new MibObjectDetails(dialogArea, 0, false, this.mibTree);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = this.nodeId != 0L ? 2 : 1;
        this.details.setLayoutData((Object)gd);
        if (this.initialSelection != null && (object = MibCache.getMibTree().findObject(this.initialSelection, false)) != null) {
            this.mibTree.setSelection(object);
        }
        return dialogArea;
    }

    private void onMibTreeSelectionChanged() {
        MibObject object = this.mibTree.getSelection();
        if (object != null && this.updateObjectId) {
            SnmpObjectId objectId = object.getObjectId();
            this.oid.setText(objectId != null ? objectId.toString() : "");
        }
        this.details.setObject(object);
    }

    protected void okPressed() {
        try {
            this.selectedObjectId = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
        }
        catch (SnmpObjectIdFormatException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid SNMP object ID or select one from the tree"));
            return;
        }
        this.selectedObject = this.mibTree.getSelection();
        if (this.selectedObject == null) {
            this.selectedObject = MibCache.getMibTree().findObject(this.selectedObjectId, false);
            if (this.selectedObject == null) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please select MIB object before pressing OK"));
                return;
            }
        }
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("MibSelectionDialog.size", size);
    }

    public MibObject getSelectedObject() {
        return this.selectedObject;
    }

    private void onManualOidChange() {
        MibObject o = MibCache.findObject((String)this.oid.getText(), (boolean)false);
        if (o != null) {
            this.updateObjectId = false;
            this.mibTree.setSelection(o);
            this.updateObjectId = true;
        }
    }

    private void doWalk() {
        try {
            SnmpValue v;
            SnmpObjectId root = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
            MibWalkDialog dlg = new MibWalkDialog(this.getShell(), this.nodeId, root);
            if (dlg.open() == 0 && (v = dlg.getValue()) != null) {
                this.oid.setText(v.getName());
            }
        }
        catch (SnmpObjectIdFormatException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Error parsing SNMP OID"));
        }
    }

    public SnmpObjectId getSelectedObjectId() {
        return this.selectedObjectId;
    }
}

