/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogColumn;
import org.netxms.nxmc.base.widgets.DashboardComposite;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.AlarmHDStateConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.AlarmStateConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.AssetOperationConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.CompletionStatusConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.EventConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.EventOriginConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.FilterBuilder;
import org.netxms.nxmc.modules.logviewer.widgets.IntegerConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.ObjectConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.SeverityConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.TextConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.TimestampConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.UserConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.ZoneConditionEditor;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class ColumnFilterEditor
extends DashboardComposite {
    private final I18n i18n = LocalizationHelper.getI18n(ColumnFilterEditor.class);
    private LogColumn column;
    private FilterBuilder filterBuilder;
    private List<ConditionEditor> conditions = new ArrayList();
    private ColumnFilterSetOperation booleanOperation = ColumnFilterSetOperation.OR;

    public ColumnFilterEditor(Composite parent, LogColumn column, ColumnFilterSetOperation operation, Runnable deleteHandler) {
        super(parent, 2048);
        this.column = column;
        this.booleanOperation = operation;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite header = new Composite((Composite)this, 0);
        header.setBackground(this.getBackground());
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 5;
        header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        header.setLayoutData((Object)gd);
        Label title = new Label(header, 0);
        title.setText(column.getDescription());
        title.setBackground(header.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        title.setLayoutData((Object)gd);
        Composite buttons = new Composite(header, 0);
        buttons.setBackground(header.getBackground());
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)gd);
        Button radioAnd = new Button(buttons, 16);
        radioAnd.setText(this.i18n.tr("&AND condition"));
        radioAnd.setBackground(buttons.getBackground());
        radioAnd.setSelection(this.booleanOperation == ColumnFilterSetOperation.AND);
        radioAnd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button radioOr = new Button(buttons, 16);
        radioOr.setText(this.i18n.tr("&OR condition"));
        radioOr.setBackground(buttons.getBackground());
        radioOr.setSelection(this.booleanOperation == ColumnFilterSetOperation.OR);
        radioOr.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.setBackground(header.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setBackground(header.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setBooleanOperation(ColumnFilterSetOperation op) {
        this.booleanOperation = op;
        String opName = op == ColumnFilterSetOperation.AND ? this.i18n.tr("AND") : this.i18n.tr("OR");
        for (int i = 1; i < this.conditions.size(); ++i) {
            ((ConditionEditor)this.conditions.get(i)).setLogicalOperation(opName);
        }
    }

    private void addCondition(ColumnFilter initialFilter) {
        ConditionEditor ce = this.createConditionEditor(initialFilter);
        ce.setDeleteHandler((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ce.setLayoutData((Object)gd);
        this.conditions.add(ce);
        if (this.conditions.size() > 1) {
            ce.setLogicalOperation(this.booleanOperation == ColumnFilterSetOperation.AND ? this.i18n.tr("AND") : this.i18n.tr("OR"));
        }
        this.filterBuilder.updateLayout();
    }

    private ConditionEditor createConditionEditor(ColumnFilter initialFilter) {
        AlarmHDStateConditionEditor editor = switch (this.column.getType()) {
            case 8 -> new AlarmHDStateConditionEditor((Composite)this);
            case 7 -> new AlarmStateConditionEditor((Composite)this);
            case 16 -> new AssetOperationConditionEditor((Composite)this);
            case 13 -> new CompletionStatusConditionEditor((Composite)this);
            case 4 -> new EventConditionEditor((Composite)this);
            case 10 -> new EventOriginConditionEditor((Composite)this);
            case 6 -> new IntegerConditionEditor((Composite)this);
            case 2 -> new ObjectConditionEditor((Composite)this);
            case 1 -> new SeverityConditionEditor((Composite)this);
            case 5 -> new TimestampConditionEditor((Composite)this);
            case 3 -> new UserConditionEditor((Composite)this);
            case 9 -> new ZoneConditionEditor((Composite)this);
            default -> new TextConditionEditor((Composite)this);
        };
        editor.initialize(initialFilter);
        return editor;
    }

    public void attachFilterBuilder(FilterBuilder filterBuilder, ColumnFilter initialFilter) {
        this.filterBuilder = filterBuilder;
        if (initialFilter == null || initialFilter.getSubFilters() == null) {
            this.addCondition((ColumnFilter)(initialFilter != null ? initialFilter : null));
        } else {
            for (ColumnFilter f : initialFilter.getSubFilters()) {
                f.setOperation(f.getOperation());
                this.addCondition(f);
            }
        }
    }

    public ColumnFilter buildFilterTree() {
        if (this.conditions.size() == 0) {
            return null;
        }
        if (this.conditions.size() > 1) {
            ColumnFilter root = new ColumnFilter();
            root.setOperation(this.booleanOperation);
            for (ConditionEditor e : this.conditions) {
                ColumnFilter filter = e.createFilter();
                root.addSubFilter(filter);
            }
            return root;
        }
        return ((ConditionEditor)this.conditions.get(0)).createFilter();
    }
}

