/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.GraphBrowser;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class GraphsPerspective
extends Perspective {
    static final I18n i18n = LocalizationHelper.getI18n(GraphsPerspective.class);
    private Object currentSelection = null;

    public GraphsPerspective() {
        super("graphs", i18n.tr("Graphs"), ResourceManager.getImage((String)"icons/perspective-graphs.png"));
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = true;
        configuration.multiViewNavigationArea = false;
        configuration.multiViewMainArea = false;
        configuration.hasSupplementalArea = false;
        configuration.priority = 22;
    }

    protected void configureViews() {
        this.addNavigationView((NavigationView)new GraphBrowser());
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (this.currentSelection == selectedElement) {
            return;
        }
        if (selectedElement != null && selectedElement instanceof GraphDefinition) {
            HistoricalGraphView view = new HistoricalGraphView();
            view.setShowDeleteAction(true);
            this.setMainView((View)view);
            view.initPredefinedGraph((GraphDefinition)selectedElement);
        } else {
            this.setMainView(null);
        }
        this.currentSelection = selectedElement;
    }
}

