/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.base.views.ConfigurationPerspective;
import org.netxms.nxmc.base.views.MonitorPerspective;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveSeparator;
import org.netxms.nxmc.base.views.PinLocation;
import org.netxms.nxmc.base.views.PinboardPerspective;
import org.netxms.nxmc.base.views.ToolsPerspective;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.modules.alarms.AlarmsPerspective;
import org.netxms.nxmc.modules.assetmanagement.AssetsPerspective;
import org.netxms.nxmc.modules.businessservice.BusinessServicesPerspective;
import org.netxms.nxmc.modules.datacollection.GraphsPerspective;
import org.netxms.nxmc.modules.logviewer.views.LogViewerPerspective;
import org.netxms.nxmc.modules.objects.DashboardsPerspective;
import org.netxms.nxmc.modules.objects.InfrastructurePerspective;
import org.netxms.nxmc.modules.objects.MapsPerspective;
import org.netxms.nxmc.modules.objects.NetworkPerspective;
import org.netxms.nxmc.modules.objects.TemplatesPerspective;
import org.netxms.nxmc.modules.objects.views.helpers.PollManager;
import org.netxms.nxmc.modules.reporting.ReportingPerspective;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Registry {
    public static final boolean IS_WEB_CLIENT = true;
    private Map<Class, Object> singletonStorage = new HashMap();
    private Map<String, Object> storage = new HashMap();
    private NXCSession session = null;
    private TimeZone timeZone = null;
    private File stateDir = null;
    private MainWindow mainWindow = null;
    private PollManager pollManager = null;
    private PinLocation lastViewPinLocation = PinLocation.PINBOARD;
    private Set<Perspective> perspectives = new HashSet();

    private static Registry getInstance() {
        return Registry.getInstance((Display)Display.getCurrent());
    }

    private static Registry getInstance(Display display) {
        Registry instance = (Registry)RWT.getUISession((Display)display).getAttribute("netxms.registry");
        if (instance == null) {
            instance = new Registry();
            RWT.getUISession((Display)display).setAttribute("netxms.registry", (Object)instance);
        }
        return instance;
    }

    public static void copyToDisplay(Display src, Display dst) {
        RWT.getUISession((Display)dst).setAttribute("netxms.registry", RWT.getUISession((Display)src).getAttribute("netxms.registry"));
    }

    public static NXCSession getSession() {
        return Registry.getInstance().session;
    }

    public static NXCSession getSession(Display display) {
        return Registry.getInstance((Display)display).session;
    }

    public static TimeZone getTimeZone() {
        return Registry.getInstance().timeZone;
    }

    public static File getStateDir() {
        return Registry.getInstance().stateDir;
    }

    public static File getStateDir(Display display) {
        return Registry.getInstance((Display)display).stateDir;
    }

    public static MainWindow getMainWindow() {
        return Registry.getInstance().mainWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getSingleton(Class<T> singletonClass) {
        Registry r = Registry.getInstance();
        Map map = r.singletonStorage;
        synchronized (map) {
            return (T)r.singletonStorage.get(singletonClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getSingleton(Class<T> singletonClass, Display display) {
        Registry r = Registry.getInstance((Display)display);
        Map map = r.singletonStorage;
        synchronized (map) {
            return (T)r.singletonStorage.get(singletonClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSingleton(Class<?> singletonClass, Object singleton) {
        Registry r = Registry.getInstance();
        Map map = r.singletonStorage;
        synchronized (map) {
            r.singletonStorage.put(singletonClass, singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSingleton(Display display, Class<?> singletonClass, Object singleton) {
        Registry r = Registry.getInstance((Display)display);
        Map map = r.singletonStorage;
        synchronized (map) {
            r.singletonStorage.put(singletonClass, singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProperty(String name) {
        Registry r = Registry.getInstance();
        Map map = r.storage;
        synchronized (map) {
            return r.storage.get("netxms." + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProperty(String name, Display display) {
        Registry r = Registry.getInstance((Display)display);
        Map map = r.storage;
        synchronized (map) {
            return r.storage.get("netxms." + name);
        }
    }

    public static boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        Object v = Registry.getProperty((String)name);
        return v != null && v instanceof Boolean ? (Boolean)v : defaultValue;
    }

    public static int getPropertyAsInteger(String name, int defaultValue) {
        Object v = Registry.getProperty((String)name);
        return v != null && v instanceof Integer ? (Integer)v : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(String name, Object value) {
        Registry r = Registry.getInstance();
        Map map = r.storage;
        synchronized (map) {
            r.storage.put("netxms." + name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(Display display, String name, Object value) {
        Registry r = Registry.getInstance((Display)display);
        Map map = r.storage;
        synchronized (map) {
            r.storage.put("netxms." + name, value);
        }
    }

    public static PollManager getPollManager() {
        return Registry.getInstance().pollManager;
    }

    private Registry() {
        this.pollManager = new PollManager();
        this.perspectives.add(new AlarmsPerspective());
        this.perspectives.add(new AssetsPerspective());
        this.perspectives.add(new BusinessServicesPerspective());
        this.perspectives.add(new ConfigurationPerspective());
        this.perspectives.add(new DashboardsPerspective());
        this.perspectives.add(new GraphsPerspective());
        this.perspectives.add(new InfrastructurePerspective());
        this.perspectives.add(new LogViewerPerspective());
        this.perspectives.add(new MapsPerspective());
        this.perspectives.add(new MonitorPerspective());
        this.perspectives.add(new NetworkPerspective());
        this.perspectives.add(new PinboardPerspective());
        this.perspectives.add(new ReportingPerspective());
        this.perspectives.add(new TemplatesPerspective());
        this.perspectives.add(new ToolsPerspective());
        this.perspectives.add(new PerspectiveSeparator(19));
        this.perspectives.add(new PerspectiveSeparator(29));
        this.perspectives.add(new PerspectiveSeparator(99));
        this.perspectives.add(new PerspectiveSeparator(149));
        this.perspectives.add(new PerspectiveSeparator(254));
    }

    public static List<Perspective> getPerspectives() {
        ArrayList<Perspective> result = new ArrayList<Perspective>(Registry.getInstance().perspectives);
        result.sort((Comparator<Perspective>)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public static void setSession(Display display, NXCSession session) {
        Registry.getInstance((Display)display).session = session;
    }

    public static void setServerTimeZone() {
        Registry instance = Registry.getInstance();
        if (instance.session != null) {
            String tz = instance.session.getServerTimeZone();
            instance.timeZone = TimeZone.getTimeZone(tz.replaceAll("[A-Za-z]+([\\+\\-][0-9]+).*", "GMT$1"));
        }
    }

    public static void resetTimeZone() {
        Registry.getInstance().timeZone = null;
    }

    protected static void setStateDir(File stateDir) {
        Registry instance = Registry.getInstance();
        if (instance.stateDir == null) {
            instance.stateDir = stateDir;
        }
    }

    protected static void setMainWindow(MainWindow window) {
        Registry instance = Registry.getInstance();
        if (instance.mainWindow == null) {
            instance.mainWindow = window;
        }
    }

    public static PinLocation getLastViewPinLocation() {
        return Registry.getInstance().lastViewPinLocation;
    }

    public static void setLastViewPinLocation(PinLocation lastViewPinLocation) {
        Registry.getInstance().lastViewPinLocation = lastViewPinLocation;
    }

    public static String getClientAddress() {
        return RWT.getRequest().getRemoteAddr();
    }
}

