/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DciContainerConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.xml.XMLTools;

public class NetworkMapDCIContainer
extends NetworkMapElement {
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private boolean borderRequired;
    private SingleDciConfig[] dciArray;

    protected NetworkMapDCIContainer(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String xml = msg.getFieldAsString(baseId + 10L);
        try {
            DciContainerConfiguration config = XMLTools.createFromXml(DciContainerConfiguration.class, xml);
            this.backgroundColor = config.getBackgroundColor();
            this.textColor = config.getTextColor();
            this.borderColor = config.getBorderColor();
            this.borderRequired = config.isBorderRequired();
            this.dciArray = config.getDciList();
        }
        catch (Exception e) {
            this.backgroundColor = 0xFFFFFF;
            this.textColor = 0x202020;
            this.borderColor = 0x202020;
            this.borderRequired = false;
            this.dciArray = null;
        }
    }

    public NetworkMapDCIContainer(long id) {
        super(id);
        this.type = 3;
        this.dciArray = null;
        this.backgroundColor = 0xFFFFFF;
        this.textColor = 0x202020;
        this.borderColor = 0x202020;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        DciContainerConfiguration config = new DciContainerConfiguration();
        config.setDciList(this.dciArray);
        config.setBackgroundColor(this.backgroundColor);
        config.setTextColor(this.textColor);
        config.setBorderColor(this.borderColor);
        config.setBorderRequired(this.borderRequired);
        try {
            msg.setField(baseId + 10L, config.createXml());
        }
        catch (Exception e) {
            msg.setField(baseId + 10L, "");
        }
    }

    public boolean hasDciData() {
        return this.dciArray != null && this.dciArray.length > 0;
    }

    public SingleDciConfig[] getObjectDCIArray() {
        return this.dciArray;
    }

    public void setObjectDCIArray(SingleDciConfig[] dciArray) {
        this.dciArray = dciArray;
    }

    public List<SingleDciConfig> getDciAsList() {
        ArrayList<SingleDciConfig> dciList = new ArrayList<SingleDciConfig>();
        if (this.hasDciData()) {
            SingleDciConfig[] singleDciConfigArray = this.dciArray;
            int n = this.dciArray.length;
            int n2 = 0;
            while (n2 < n) {
                SingleDciConfig dci = singleDciConfigArray[n2];
                dciList.add(dci);
                ++n2;
            }
        }
        return dciList;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderRequired() {
        return this.borderRequired;
    }

    public void setBorderRequired(boolean borderRequired) {
        this.borderRequired = borderRequired;
    }
}

