/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AccessListComparator;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.AccessListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.usermanager.dialogs.UserSelectionDialog;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AccessControl
extends PropertyPage {
    private AbstractObject object;
    private SortableTableViewer userList;
    private HashMap<Integer, Button> accessChecks = new HashMap(11);
    private HashMap<Integer, AccessListElement> acl;
    private Button checkInherit;
    private NXCSession session;

    protected Control createContents(Composite parent) {
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        this.session = ConsoleSharedData.getSession();
        AccessListElement[] origAcl = this.object.getAccessList();
        this.acl = new HashMap(origAcl.length);
        int i = 0;
        while (i < origAcl.length) {
            this.acl.put(origAcl[i].getUserId(), new AccessListElement(origAcl[i]));
            ++i;
        }
        this.collectInheritedAccessRights(this.object);
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group users = new Group(dialogArea, 0);
        Messages.get();
        users.setText(Messages.AccessControl_UsersGroups);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        users.setLayoutData((Object)gd);
        layout = new GridLayout();
        users.setLayout((Layout)layout);
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.AccessControl_ColLogin;
        Messages.get();
        stringArray[1] = Messages.AccessControl_ColRights;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{220, 180};
        this.userList = new SortableTableViewer((Composite)users, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.userList.setComparator((ViewerComparator)new AccessListComparator());
        this.userList.setInput((Object)this.acl.values().toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)users, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.AccessControl_Add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserSelectionDialog dlg = new UserSelectionDialog(AccessControl.this.getShell(), AbstractUserObject.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        AccessListElement curr = AccessControl.this.acl.get(user.getId());
                        if (curr == null || curr.isInherited()) {
                            AccessControl.this.acl.put(user.getId(), new AccessListElement(user.getId(), 0));
                        }
                        ++n2;
                    }
                    AccessControl.this.userList.setInput((Object)AccessControl.this.acl.values().toArray());
                    AccessControl.this.userList.setSelection((ISelection)new StructuredSelection((Object)AccessControl.this.acl.get(selection[0].getId())));
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.AccessControl_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = AccessControl.this.userList.getStructuredSelection();
                for (AccessListElement element : selection) {
                    if (element.isInherited()) continue;
                    AccessControl.this.acl.remove(element.getUserId());
                }
                AccessControl.this.collectInheritedAccessRights(AccessControl.this.object);
                AccessControl.this.userList.setInput((Object)AccessControl.this.acl.values().toArray());
            }
        });
        Group rights = new Group(dialogArea, 0);
        Messages.get();
        rights.setText(Messages.AccessControl_AccessRights);
        rights.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        rights.setLayoutData((Object)gd);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessRead, 1);
        this.createAccessCheck((Composite)rights, "Read agent data", 65536);
        this.createAccessCheck((Composite)rights, "Read SNMP data", 131072);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessModify, 2);
        this.createAccessCheck((Composite)rights, "Edit comments", 0x200000);
        this.createAccessCheck((Composite)rights, "Manage responsible users", 0x400000);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessCreate, 4);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessDelete, 8);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessControl, 256);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessSendEvents, 128);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessViewAlarms, 16);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessUpdateAlarms, 64);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessTermAlarms, 512);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_CreateTicket, 2048);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessPushData, 1024);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_AccessAccessControl, 32);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_DownloadFiles, 4096);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_UploadFiles, 8192);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.AccessControl_ManageFiles, 16384);
        this.createAccessCheck((Composite)rights, "Configure agent", 0x100000);
        this.createAccessCheck((Composite)rights, "Take screenshot", 262144);
        this.createAccessCheck((Composite)rights, "Control maintenance mode", 32768);
        this.createAccessCheck((Composite)rights, "Edit maintenance journal", 524288);
        this.userList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    AccessListElement element = (AccessListElement)selection.getFirstElement();
                    int rights = element.getAccessRights();
                    int i = 0;
                    int mask = 1;
                    while (i < AccessControl.this.accessChecks.size()) {
                        Button check = AccessControl.this.accessChecks.get(mask);
                        if (check != null) {
                            check.setSelection((rights & mask) == mask);
                        }
                        ++i;
                        mask <<= 1;
                    }
                    AccessControl.this.enableAllChecks(!element.isInherited());
                } else {
                    AccessControl.this.enableAllChecks(false);
                }
                if (selection.size() > 0) {
                    boolean allowDelete = true;
                    for (Object o : selection.toList()) {
                        if (!((AccessListElement)o).isInherited()) continue;
                        allowDelete = false;
                        break;
                    }
                    deleteButton.setEnabled(allowDelete);
                } else {
                    deleteButton.setEnabled(false);
                }
            }
        });
        this.checkInherit = new Button(dialogArea, 32);
        Messages.get();
        this.checkInherit.setText(Messages.AccessControl_InheritRights);
        if (this.object.getParentCount() > 0) {
            this.checkInherit.setSelection(this.object.isInheritAccessRights());
        } else {
            this.checkInherit.setSelection(false);
            this.checkInherit.setEnabled(false);
        }
        this.checkInherit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int oldAclSize = AccessControl.this.acl.size();
                if (AccessControl.this.checkInherit.getSelection()) {
                    AccessControl.this.collectInheritedAccessRights(AccessControl.this.object);
                } else {
                    ArrayList<Integer> deleteList = new ArrayList<Integer>();
                    for (AccessListElement element : AccessControl.this.acl.values()) {
                        if (!element.isInherited()) continue;
                        deleteList.add(element.getUserId());
                    }
                    for (Integer id : deleteList) {
                        AccessControl.this.acl.remove(id);
                    }
                }
                if (AccessControl.this.acl.size() != oldAclSize) {
                    AccessControl.this.userList.setInput((Object)AccessControl.this.acl.values().toArray());
                }
            }
        });
        this.syncUsersAndRefresh();
        return dialogArea;
    }

    private void collectInheritedAccessRights(AbstractObject currentObject) {
        if (!currentObject.isInheritAccessRights()) {
            return;
        }
        AbstractObject[] abstractObjectArray = currentObject.getParentsAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject o = abstractObjectArray[n2];
            AccessListElement[] accessListElementArray = o.getAccessList();
            int n3 = accessListElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AccessListElement e = accessListElementArray[n4];
                if (!this.acl.containsKey(e.getUserId())) {
                    this.acl.put(e.getUserId(), new AccessListElement(e, true));
                }
                ++n4;
            }
            this.collectInheritedAccessRights(o);
            ++n2;
        }
    }

    private void syncUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        ConsoleJob job = new ConsoleJob("Synchronize users", null, "org.netxms.ui.eclipse.objectmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (AccessControl.this.session.syncMissingUsers(AccessControl.this.acl.keySet())) {
                    this.runInUIThread(() -> AccessControl.this.userList.refresh());
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        job.setUser(false);
        job.start();
    }

    private void createAccessCheck(Composite parent, String name, final Integer bitMask) {
        final Button check = new Button(parent, 32);
        check.setText(name);
        check.setEnabled(false);
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AccessControl.this.userList.getSelection();
                AccessListElement element = (AccessListElement)sel.getFirstElement();
                int rights = element.getAccessRights();
                rights = check.getSelection() ? (rights |= bitMask.intValue()) : (rights &= ~bitMask.intValue());
                element.setAccessRights(rights);
                AccessControl.this.userList.update((Object)element, null);
            }
        });
        this.accessChecks.put(bitMask, check);
    }

    private void enableAllChecks(boolean enabled) {
        for (Button b : this.accessChecks.values()) {
            b.setEnabled(enabled);
        }
    }

    private boolean applyChanges(final boolean isApply) {
        boolean inheritAccessRights = this.checkInherit.getSelection();
        List accessRights = this.acl.values().stream().filter(e -> !e.isInherited()).collect(Collectors.toList());
        if (!inheritAccessRights && accessRights.isEmpty() && !MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Access Control Warning", (String)"There are no direct or inherited access control rules for this object. If you continue with this change, object will be accessible only by the user \"system\". Do you want to proceed?")) {
            this.checkInherit.setSelection(true);
            this.collectInheritedAccessRights(this.object);
            this.userList.setInput((Object)this.acl.values().toArray());
            return false;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setACL(accessRights);
        md.setInheritAccessRights(inheritAccessRights);
        Messages.get();
        new ConsoleJob(String.format(Messages.AccessControl_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AccessControl.this.session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(() -> AccessControl.this.setValid(true));
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AccessControl_JobError;
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkInherit.setSelection(true);
        this.acl.clear();
        this.userList.setInput((Object)this.acl.values().toArray());
    }
}

