/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.base.NXCPMessage;

public class DciSummaryTableColumn {
    public static int REGEXP_MATCH = 1;
    public static int MULTIVALUED = 2;
    public static int DESCRIPTION_MATCH = 4;
    private String name;
    private String dciName;
    private int flags;
    private String separator;

    public DciSummaryTableColumn(String name, String dciName, int flags, String separator) {
        this.name = name;
        this.dciName = dciName;
        this.flags = flags;
        this.separator = separator;
    }

    public DciSummaryTableColumn(String name, String dciName, int flags) {
        this(name, dciName, flags, ";");
    }

    public DciSummaryTableColumn(String name, String dciName) {
        this(name, dciName, 0, ";");
    }

    public DciSummaryTableColumn(DciSummaryTableColumn src) {
        this.name = src.name;
        this.dciName = src.dciName;
        this.flags = src.flags;
        this.separator = src.separator;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setField(baseId, this.name);
        msg.setField(baseId + 1L, this.dciName);
        msg.setFieldInt32(baseId + 2L, this.flags);
        msg.setField(baseId + 3L, this.separator);
    }

    public String getName() {
        return this.name;
    }

    public String getDciName() {
        return this.dciName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDciName(String dciName) {
        this.dciName = dciName;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator != null && !separator.isEmpty() ? separator : ";";
    }

    public boolean isDescriptionMatch() {
        return (this.flags & DESCRIPTION_MATCH) != 0;
    }

    public void setDescriptionMatch(boolean enable) {
        this.flags = enable ? (this.flags |= DESCRIPTION_MATCH) : (this.flags &= ~DESCRIPTION_MATCH);
    }

    public boolean isRegexpMatch() {
        return (this.flags & REGEXP_MATCH) != 0;
    }

    public void setRegexpMatch(boolean enable) {
        this.flags = enable ? (this.flags |= REGEXP_MATCH) : (this.flags &= ~REGEXP_MATCH);
    }

    public boolean isMultivalued() {
        return (this.flags & MULTIVALUED) != 0;
    }

    public void setMultivalued(boolean enable) {
        this.flags = enable ? (this.flags |= MULTIVALUED) : (this.flags &= ~MULTIVALUED);
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        return "DciSummaryTableColumn [name=" + this.name + ", dciName=" + this.dciName + ", flags=" + this.flags + ", separator=" + this.separator + "]";
    }
}

