/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ServerActionType {
    LOCAL_COMMAND(0),
    AGENT_COMMAND(1),
    SSH_COMMAND(2),
    NOTIFICATION(3),
    FORWARD_EVENT(4),
    NXSL_SCRIPT(5);

    private static Logger logger;
    private static Map<Integer, ServerActionType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(ServerActionType.class);
        lookupTable = new HashMap<Integer, ServerActionType>();
        ServerActionType[] serverActionTypeArray = ServerActionType.values();
        int n = serverActionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerActionType element = serverActionTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private ServerActionType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ServerActionType getByValue(int value) {
        ServerActionType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return LOCAL_COMMAND;
        }
        return element;
    }
}

