/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.client.ServerAction;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.Section;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.actions.dialogs.ActionSelectionDialog;
import org.netxms.nxmc.modules.actions.views.helpers.ActionComparator;
import org.netxms.nxmc.modules.actions.views.helpers.ActionLabelProvider;
import org.netxms.nxmc.modules.assetmanagement.dialogs.SelectAssetAttributeDlg;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectWebServiceDlg;
import org.netxms.nxmc.modules.events.dialogs.EventSelectionDialog;
import org.netxms.nxmc.modules.events.dialogs.RuleSelectionDialog;
import org.netxms.nxmc.modules.events.widgets.helpers.BaseEventTemplateLabelProvider;
import org.netxms.nxmc.modules.nxsl.dialogs.SelectScriptDialog;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.serverconfig.dialogs.ObjectToolSelectionDialog;
import org.netxms.nxmc.modules.serverconfig.dialogs.SelectSnmpTrapDialog;
import org.netxms.nxmc.modules.serverconfig.dialogs.SummaryTableSelectionDialog;
import org.netxms.nxmc.modules.serverconfig.dialogs.helpers.TrapListLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.ExportFileBuilder;
import org.netxms.nxmc.modules.serverconfig.views.helpers.RuleComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.RuleLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ScriptComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ScriptLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.SummaryTablesComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.SummaryTablesLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ToolComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ToolLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExportFileBuilder
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(ExportFileBuilder.class);
    private NXCSession session = Registry.getSession();
    private Composite content;
    private Text description;
    private TableViewer actionViewer;
    private TableViewer eventViewer;
    private TableViewer ruleViewer;
    private TableViewer scriptViewer;
    private TableViewer summaryTableViewer;
    private TableViewer templateViewer;
    private TableViewer toolsViewer;
    private TableViewer trapViewer;
    private TableViewer webServiceViewer;
    private TableViewer assetAttributeViewer;
    private Action actionExport;
    private Action actionClear;
    private Map<Long, ServerAction> actions = new HashMap();
    private Map<Long, EventTemplate> events = new HashMap();
    private Map<UUID, EventProcessingPolicyRule> rules = new HashMap();
    private Map<Long, Script> scripts = new HashMap();
    private Map<Integer, DciSummaryTableDescriptor> summaryTables = new HashMap();
    private Map<Long, Template> templates = new HashMap();
    private Map<Long, ObjectTool> tools = new HashMap();
    private Map<Long, SnmpTrap> traps = new HashMap();
    private Map<Integer, WebServiceDefinition> webServices = new HashMap();
    private Map<String, AssetAttribute> assetAttributes = new HashMap();
    private boolean modified = false;
    private List<SnmpTrap> snmpTrapCache = null;
    private List<EventProcessingPolicyRule> rulesCache = null;

    public ExportFileBuilder() {
        super(LocalizationHelper.getI18n(ExportFileBuilder.class).tr("Export Configuration"), ResourceManager.getImageDescriptor((String)"icons/config-views/export.png"), "config.export", false);
    }

    public void createContent(Composite parent) {
        ScrolledComposite scroller = new ScrolledComposite(parent, 512);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)scroller, (int)512, (int)20);
        scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.content = new Composite((Composite)scroller, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        this.content.setLayout((Layout)layout);
        this.content.setBackground(this.content.getDisplay().getSystemColor(25));
        scroller.setContent((Control)this.content);
        this.createDescriptionSection();
        this.createTemplatesSection();
        this.createEventSection();
        this.createTrapSection();
        this.createRuleSection();
        this.createScriptSection();
        this.createToolsSection();
        this.createSummaryTablesSection();
        this.createActionsSection();
        this.createWebServiceSection();
        this.createAssetAttributesSection();
        this.createActions();
    }

    private void createDescriptionSection() {
        Section section = new Section(this.content, this.i18n.tr("Description"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.description = new Text(clientArea, 770);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.description.setLayoutData((Object)gd);
    }

    private void createTemplatesSection() {
        Section section = new Section(this.content, this.i18n.tr("Templates"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.templateViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.templateViewer.getTable().setLayoutData((Object)gd);
        this.templateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
        this.templateViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.templateViewer.getLabelProvider()));
        this.templateViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createEventSection() {
        Section section = new Section(this.content, this.i18n.tr("Events"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.eventViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.eventViewer.getTable().setLayoutData((Object)gd);
        this.eventViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new BaseEventTemplateLabelProvider());
        this.eventViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.eventViewer.getLabelProvider()));
        this.eventViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createTrapSection() {
        Section section = new Section(this.content, this.i18n.tr("SNMP Traps"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.trapViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.trapViewer.getTable().setLayoutData((Object)gd);
        this.trapViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.trapViewer.setLabelProvider((IBaseLabelProvider)new TrapListLabelProvider());
        this.trapViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.trapViewer.getLabelProvider()));
        this.trapViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createRuleSection() {
        Section section = new Section(this.content, this.i18n.tr("Event Processing Rules"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.ruleViewer = new TableViewer(clientArea, 65538);
        this.ruleViewer.getTable().setLinesVisible(true);
        this.ruleViewer.getTable().setHeaderVisible(true);
        TableColumn column = new TableColumn(this.ruleViewer.getTable(), 16384);
        column.setText("Rule #");
        column.setWidth(60);
        column = new TableColumn(this.ruleViewer.getTable(), 16384);
        column.setText("Rule Name");
        column.setWidth(250);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.ruleViewer.getTable().setLayoutData((Object)gd);
        this.ruleViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ruleViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.ruleViewer.setComparator((ViewerComparator)new RuleComparator());
        this.ruleViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createScriptSection() {
        Section section = new Section(this.content, this.i18n.tr("Scripts"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.scriptViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.scriptViewer.getTable().setLayoutData((Object)gd);
        this.scriptViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.scriptViewer.setLabelProvider((IBaseLabelProvider)new ScriptLabelProvider());
        this.scriptViewer.setComparator((ViewerComparator)new ScriptComparator());
        this.scriptViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createToolsSection() {
        Section section = new Section(this.content, this.i18n.tr("Object Tools"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.toolsViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.toolsViewer.getTable().setLayoutData((Object)gd);
        this.toolsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.toolsViewer.setLabelProvider((IBaseLabelProvider)new ToolLabelProvider());
        this.toolsViewer.setComparator((ViewerComparator)new ToolComparator());
        this.toolsViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createSummaryTablesSection() {
        Section section = new Section(this.content, this.i18n.tr("Summary Tables"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.summaryTableViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.summaryTableViewer.getTable().setLayoutData((Object)gd);
        this.summaryTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.summaryTableViewer.setLabelProvider((IBaseLabelProvider)new SummaryTablesLabelProvider());
        this.summaryTableViewer.setComparator((ViewerComparator)new SummaryTablesComparator());
        this.summaryTableViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createActionsSection() {
        Section section = new Section(this.content, this.i18n.tr("Actions"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.actionViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.actionViewer.getTable().setLayoutData((Object)gd);
        this.actionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.actionViewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider());
        this.actionViewer.setComparator((ViewerComparator)new ActionComparator());
        this.actionViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createWebServiceSection() {
        Section section = new Section(this.content, this.i18n.tr("Web Service Definitions"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.webServiceViewer = new TableViewer(clientArea, 65538);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.webServiceViewer.getTable().setLayoutData((Object)gd);
        this.webServiceViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.webServiceViewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.webServiceViewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.webServiceViewer.getTable().setSortDirection(128);
        Label separator = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        separator.setLayoutData((Object)gd);
        Composite controlArea = new Composite(clientArea, 0);
        controlArea.setBackground(clientArea.getBackground());
        controlArea.setLayout((Layout)new GridLayout());
        controlArea.setLayoutData((Object)new GridData(4, 4, false, true));
        ImageHyperlink linkAdd = new ImageHyperlink(controlArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(controlArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createAssetAttributesSection() {
        Section section = new Section(this.content, this.i18n.tr("Asset Attributes"), false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        section.setLayoutData((Object)gd);
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        clientArea.setBackground(this.content.getBackground());
        this.assetAttributeViewer = new TableViewer(clientArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.assetAttributeViewer.getTable().setLayoutData((Object)gd);
        this.assetAttributeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.assetAttributeViewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.assetAttributeViewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.assetAttributeViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = new ImageHyperlink(clientArea, 0);
        linkAdd.setText(this.i18n.tr("Add..."));
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        linkAdd.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink(clientArea, 0);
        linkRemove.setText(this.i18n.tr("Remove"));
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        linkRemove.setBackground(clientArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createActions() {
        this.actionExport = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+E", (IAction)this.actionExport);
        this.actionExport.setEnabled(false);
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClear);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExport);
        manager.add((IAction)this.actionClear);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExport);
        manager.add((IAction)this.actionClear);
    }

    private void doExport(ExportCompletionHandler completionHandler) {
        long[] eventList = new long[this.events.size()];
        int i = 0;
        for (Object t : this.events.values()) {
            eventList[i++] = t.getCode();
        }
        long[] templateList = new long[this.templates.size()];
        i = 0;
        for (Object t : this.templates.values()) {
            templateList[i++] = t.getObjectId();
        }
        long[] trapList = new long[this.traps.size()];
        i = 0;
        for (Object t : this.traps.values()) {
            trapList[i++] = t.getId();
        }
        UUID[] ruleList = new UUID[this.rules.size()];
        i = 0;
        for (Object r : this.rules.values()) {
            ruleList[i++] = r.getGuid();
        }
        long[] scriptList = new long[this.scripts.size()];
        i = 0;
        for (Object s : this.scripts.values()) {
            scriptList[i++] = s.getId();
        }
        long[] toolList = new long[this.tools.size()];
        i = 0;
        for (Object t : this.tools.values()) {
            toolList[i++] = t.getId();
        }
        long[] summaryTableList = new long[this.summaryTables.size()];
        i = 0;
        for (Object t : this.summaryTables.values()) {
            summaryTableList[i++] = t.getId();
        }
        long[] actionList = new long[this.actions.size()];
        i = 0;
        for (Object a : this.actions.values()) {
            actionList[i++] = a.getId();
        }
        long[] webServiceList = new long[this.webServices.size()];
        i = 0;
        for (Object a : this.webServices.values()) {
            webServiceList[i++] = a.getId();
        }
        String[] assetAttributesList = new String[this.assetAttributes.size()];
        i = 0;
        for (AssetAttribute a : this.assetAttributes.values()) {
            assetAttributesList[i++] = a.getName();
        }
        String descriptionText = this.description.getText();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void save() {
        this.doExport((ExportCompletionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static Object keyFromObject(Object o) {
        if (o instanceof DciSummaryTableDescriptor) {
            return ((DciSummaryTableDescriptor)o).getId();
        }
        if (o instanceof EventProcessingPolicyRule) {
            return ((EventProcessingPolicyRule)o).getGuid();
        }
        if (o instanceof EventTemplate) {
            return ((EventTemplate)o).getCode();
        }
        if (o instanceof ObjectTool) {
            return ((ObjectTool)o).getId();
        }
        if (o instanceof Script) {
            return ((Script)o).getId();
        }
        if (o instanceof ServerAction) {
            return ((ServerAction)o).getId();
        }
        if (o instanceof SnmpTrap) {
            return ((SnmpTrap)o).getId();
        }
        if (o instanceof Template) {
            return ((Template)o).getObjectId();
        }
        if (o instanceof WebServiceDefinition) {
            return ((WebServiceDefinition)o).getId();
        }
        if (o instanceof AssetAttribute) {
            return ((AssetAttribute)o).getName();
        }
        return null;
    }

    private void removeObjects(TableViewer viewer, Map<?, ?> objects) {
        IStructuredSelection selection = viewer.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                objects.remove(ExportFileBuilder.keyFromObject(o));
            }
            viewer.setInput((Object)objects.values().toArray());
            this.setModified();
        }
    }

    private void addEvents() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getWindow().getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            for (EventTemplate t : dlg.getSelectedEvents()) {
                this.events.put(t.getCode(), t);
            }
            this.eventViewer.setInput((Object)this.events.values().toArray());
            this.setModified();
        }
    }

    private void addTemplates() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createTemplateSelectionFilter());
        dlg.enableMultiSelection(true);
        dlg.showFilterToolTip(false);
        if (dlg.open() == 0) {
            HashSet<Long> idList = new HashSet<Long>();
            for (AbstractObject o : dlg.getSelectedObjects()) {
                if (o instanceof TemplateGroup) {
                    Set children = ((TemplateGroup)o).getAllChildren(8);
                    for (AbstractObject child : children) {
                        this.templates.put(((Template)child).getObjectId(), (Template)child);
                        idList.add(child.getObjectId());
                    }
                    continue;
                }
                if (!(o instanceof Template)) continue;
                this.templates.put(((Template)o).getObjectId(), (Template)o);
                idList.add(o.getObjectId());
            }
            this.templateViewer.setInput((Object)this.templates.values().toArray());
            this.setModified();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void addTraps() {
        SelectSnmpTrapDialog dlg = new SelectSnmpTrapDialog(this.getWindow().getShell(), this.snmpTrapCache);
        if (dlg.open() == 0) {
            HashSet<Long> eventCodes = new HashSet<Long>();
            for (SnmpTrap t : dlg.getSelection()) {
                this.traps.put(t.getId(), t);
                if (t.getEventCode() < 100000) continue;
                eventCodes.add(Long.valueOf(t.getEventCode()));
            }
            this.trapViewer.setInput((Object)this.traps.values().toArray());
            this.setModified();
            if (eventCodes.size() > 0) {
                for (SnmpTrap t : this.session.findMultipleEventTemplates(eventCodes)) {
                    this.events.put(t.getCode(), t);
                }
                this.eventViewer.setInput((Object)this.events.values().toArray());
            }
        }
    }

    private void addRules() {
        RuleSelectionDialog dlg = new RuleSelectionDialog(this.getWindow().getShell(), this.rulesCache);
        if (dlg.open() == 0) {
            HashSet<Long> eventCodes = new HashSet<Long>();
            for (EventProcessingPolicyRule r : dlg.getSelectedRules()) {
                this.rules.put(r.getGuid(), r);
                for (Long e : r.getEvents()) {
                    if (e < 100000L) continue;
                    eventCodes.add(e);
                }
            }
            this.ruleViewer.setInput((Object)this.rules.values().toArray());
            this.setModified();
            if (eventCodes.size() > 0) {
                for (EventTemplate t : this.session.findMultipleEventTemplates(eventCodes)) {
                    this.events.put(t.getCode(), t);
                }
                this.eventViewer.setInput((Object)this.events.values().toArray());
            }
        }
    }

    private void addScripts() {
        SelectScriptDialog dlg = new SelectScriptDialog(this.getWindow().getShell());
        dlg.setMultiSelection(true);
        if (dlg.open() == 0) {
            for (Script s : dlg.getSelection()) {
                this.scripts.put(s.getId(), s);
            }
            this.scriptViewer.setInput((Object)this.scripts.values().toArray());
            this.setModified();
        }
    }

    private void addObjectTools() {
        ObjectToolSelectionDialog dlg = new ObjectToolSelectionDialog(this.getWindow().getShell());
        if (dlg.open() == 0) {
            for (ObjectTool t : dlg.getSelection()) {
                this.tools.put(t.getId(), t);
            }
            this.toolsViewer.setInput((Object)this.tools.values().toArray());
            this.setModified();
        }
    }

    private void addSummaryTables() {
        SummaryTableSelectionDialog dlg = new SummaryTableSelectionDialog(this.getWindow().getShell());
        if (dlg.open() == 0) {
            for (DciSummaryTableDescriptor t : dlg.getSelection()) {
                this.summaryTables.put(t.getId(), t);
            }
            this.summaryTableViewer.setInput((Object)this.summaryTables.values().toArray());
            this.setModified();
        }
    }

    private void addActions() {
        ActionSelectionDialog dlg = new ActionSelectionDialog(this.getWindow().getShell());
        if (dlg.open() == 0) {
            for (ServerAction a : dlg.getSelection()) {
                this.actions.put(a.getId(), a);
            }
            this.actionViewer.setInput((Object)this.actions.values().toArray());
            this.setModified();
        }
    }

    private void addWebServiceDefinitions() {
        SelectWebServiceDlg dlg = new SelectWebServiceDlg(this.getWindow().getShell(), true);
        if (dlg.open() == 0) {
            for (WebServiceDefinition service : dlg.getSelection()) {
                this.webServices.put(service.getId(), service);
            }
            this.webServiceViewer.setInput((Object)this.webServices.values().toArray());
            this.setModified();
        }
    }

    private void addAssetAttributes() {
        SelectAssetAttributeDlg dlg = new SelectAssetAttributeDlg(this.getWindow().getShell());
        if (dlg.open() == 0) {
            for (AssetAttribute service : dlg.getSelectedAttributes()) {
                this.assetAttributes.put(service.getName(), service);
            }
            this.assetAttributeViewer.setInput((Object)this.assetAttributes.values().toArray());
            this.setModified();
        }
    }

    private void clear() {
        this.description.setText("");
        this.actions.clear();
        this.events.clear();
        this.rules.clear();
        this.scripts.clear();
        this.summaryTables.clear();
        this.templates.clear();
        this.traps.clear();
        this.tools.clear();
        this.webServices.clear();
        this.assetAttributes.clear();
        this.actionViewer.setInput((Object)new Object[0]);
        this.eventViewer.setInput((Object)new Object[0]);
        this.ruleViewer.setInput((Object)new Object[0]);
        this.scriptViewer.setInput((Object)new Object[0]);
        this.summaryTableViewer.setInput((Object)new Object[0]);
        this.templateViewer.setInput((Object)new Object[0]);
        this.toolsViewer.setInput((Object)new Object[0]);
        this.trapViewer.setInput((Object)new Object[0]);
        this.webServiceViewer.setInput((Object)new Object[0]);
        this.assetAttributeViewer.setInput((Object)new Object[0]);
        this.modified = false;
        this.actionExport.setEnabled(false);
    }

    private void setModified() {
        this.modified = true;
        this.actionExport.setEnabled(true);
    }

    public boolean isModified() {
        return this.modified;
    }
}

