/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.views;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objecttools.views.ObjectToolResultView;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractCommandResultView
extends ObjectToolResultView {
    private I18n i18n = LocalizationHelper.getI18n(AbstractCommandResultView.class);
    protected String executionString;
    protected Map<String, String> inputValues;
    protected List<String> maskedFields;
    protected TextConsole console;
    protected long streamId = 0L;
    private TextConsole.IOConsoleOutputStream out;
    private TextOutputListener outputListener;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;

    public AbstractCommandResultView(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields) {
        super(node, tool, ResourceManager.getImageDescriptor((String)"icons/object-tools/terminal.png"), false);
        this.inputValues = inputValues;
        this.maskedFields = maskedFields;
        this.executionString = tool.getData();
        this.outputListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected AbstractCommandResultView() {
    }

    public View cloneView() {
        AbstractCommandResultView view = (AbstractCommandResultView)super.cloneView();
        view.inputValues = this.inputValues;
        view.maskedFields = this.maskedFields;
        view.executionString = this.executionString;
        view.outputListener = new /* Unavailable Anonymous Inner Class!! */;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        AbstractCommandResultView origin = (AbstractCommandResultView)view;
        this.console.setText(origin.console.getText());
    }

    protected void createContent(Composite parent) {
        this.console = new TextConsole(parent, 0);
        this.console.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.execute();
    }

    protected void createActions() {
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actionScrollLock.setChecked(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected abstract void execute();

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.console);
        this.console.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.console.setFocus();
    }

    public void dispose() {
        this.closeOutputStream();
        super.dispose();
    }

    protected TextOutputListener getOutputListener() {
        return this.outputListener;
    }

    protected void createOutputStream() {
        this.closeOutputStream();
        this.out = this.console.newOutputStream();
    }

    protected void closeOutputStream() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out = null;
    }

    protected void writeToOutputStream(String text) {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

