/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.LoadingObject;
import org.netxms.client.objects.Node;

public class ObjectTreeContentProvider
extends TreeNodeContentProvider {
    private NXCSession session = null;
    private Set<Integer> classFilter;
    private ObjectFilter objectFilter;
    private boolean objectFullSync = false;

    public ObjectTreeContentProvider(boolean objectFullSync, Set<Integer> classFilter, ObjectFilter objectFilter) {
        this.classFilter = classFilter;
        this.objectFilter = objectFilter;
        this.objectFullSync = objectFullSync;
    }

    public Object[] getChildren(Object parentElement) {
        AbstractObject object = (AbstractObject)parentElement;
        if (!this.objectFullSync && object instanceof Node && object.hasChildren() && !object.areChildrenSynchronized()) {
            return new AbstractObject[]{new LoadingObject(-1L, this.session)};
        }
        return object.getChildrenAsArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.session != null) {
            if (this.objectFilter == null) {
                return this.session.getTopLevelObjects(this.classFilter);
            }
            if (this.classFilter == null) {
                return this.session.getTopLevelObjects(this.objectFilter);
            }
            return this.session.getTopLevelObjects(o -> this.classFilter.contains(o.getObjectClass()) && this.objectFilter.accept(o));
        }
        return new AbstractObject[0];
    }

    public Object getParent(Object element) {
        if (this.session == null) {
            return null;
        }
        Iterator it = ((AbstractObject)element).getParents();
        return it.hasNext() ? this.session.findObjectById(((Long)it.next()).longValue()) : null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Node ? ((AbstractObject)element).hasChildren() : ((AbstractObject)element).hasAccessibleChildren();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.session = (NXCSession)newInput;
    }
}

