/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.xnap.commons.i18n.I18n;

public abstract class TableElement
extends OverviewPageElement {
    private final I18n i18n = LocalizationHelper.getI18n(TableElement.class);
    private Table table;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyValue;

    public TableElement(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected Control createClientArea(Composite parent) {
        this.table = new Table(parent, 98564);
        this.setupTable();
        this.createActions();
        this.createPopupMenu();
        this.fillTableInternal();
        return this.table;
    }

    private void setupTable() {
        TableColumn tc = new TableColumn(this.table, 16384);
        tc.setText(this.i18n.tr("Name"));
        tc = new TableColumn(this.table, 16384);
        tc.setText(this.i18n.tr("Value"));
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
    }

    protected void createActions() {
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyValue = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopyValue);
    }

    protected abstract void fillTable();

    private void fillTableInternal() {
        if (this.getObject() == null) {
            return;
        }
        this.fillTable();
        this.table.getColumn(0).pack();
        this.table.getColumn(1).pack();
    }

    protected void addPair(String attr, String value, boolean allowEmpty) {
        if (!allowEmpty && (value == null || value.isEmpty())) {
            return;
        }
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, attr);
        item.setText(1, value != null ? value : "");
    }

    protected void addPair(String attr, String value) {
        this.addPair(attr, value, true);
    }

    protected void onObjectChange() {
        this.table.removeAll();
        this.fillTableInternal();
    }
}

