/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.helpers.LineStyler;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.views.AgentFileViewer;
import org.netxms.nxmc.modules.filemanager.widgets.BaseFileViewer;
import org.netxms.nxmc.modules.filemanager.widgets.DynamicFileViewer;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgentFileViewer
extends AdHocObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(AgentFileViewer.class);
    private DynamicFileViewer viewer;
    private AgentFileData remoteFile;
    private boolean followChanges;
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionCopy;
    private Action actionSelectAll;
    private Action actionFind;

    protected AgentFileViewer(long objectId, AgentFileData remoteFile, boolean followChanges, long contextId) {
        super(LocalizationHelper.getI18n(AgentFileViewer.class).tr("Remote File"), ResourceManager.getImageDescriptor((String)"icons/object-views/file-view.png"), remoteFile.getRemoteName(), objectId, contextId, false);
        this.remoteFile = remoteFile;
        this.followChanges = followChanges;
        this.setName(remoteFile.getRemoteName());
    }

    protected AgentFileViewer() {
        super(null, null, null, 0L, 0L, false);
    }

    public View cloneView() {
        AgentFileViewer view = (AgentFileViewer)super.cloneView();
        view.remoteFile = this.remoteFile;
        view.followChanges = this.followChanges;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        AgentFileViewer origin = (AgentFileViewer)view;
        this.viewer.setLineStyler(origin.viewer.getLineStyler());
        this.viewer.replaceContent((BaseFileViewer)origin.viewer, this.followChanges);
        if (this.followChanges) {
            1 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        }
    }

    protected void createContent(Composite parent) {
        this.viewer = new DynamicFileViewer(parent, 0, (View)this);
        this.viewer.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionClear = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+L", (IAction)this.actionClear);
        this.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actionScrollLock.setChecked(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.filemanager.commands.copy");
        this.addKeyBinding("Ctrl+C", (IAction)this.actionCopy);
        this.actionSelectAll = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+A", (IAction)this.actionSelectAll);
        this.actionFind = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+F", (IAction)this.actionFind);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
        manager.add((IContributionItem)new Separator());
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getTextControl());
        this.viewer.getTextControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionFind);
        if (this.followChanges) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionClear);
            manager.add((IAction)this.actionScrollLock);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public static boolean createView(ViewPlacement view, long nodeId, AgentFileData file, boolean followChanges, long contextId) {
        return AgentFileViewer.createView((ViewPlacement)view, (long)nodeId, (AgentFileData)file, (boolean)followChanges, (boolean)false, (long)contextId, null);
    }

    public static boolean createView(ViewPlacement viewPlacement, long nodeId, AgentFileData file, boolean followChanges, boolean ignoreContext, long contextId, LineStyler lineStyler) {
        boolean exceedSize;
        I18n i18n = LocalizationHelper.getI18n(AgentFileViewer.class);
        boolean bl = exceedSize = file.getFile().length() > 0x4000000L;
        if (exceedSize && !MessageDialogHelper.openConfirm((Shell)viewPlacement.getWindow().getShell(), (String)i18n.tr("Large File"), (String)i18n.tr("File is too large to be displayed in full. Click OK to see beginning of the file."))) {
            if (followChanges) {
                NXCSession session = Registry.getSession();
                9 job = new /* Unavailable Anonymous Inner Class!! */;
                job.setUser(false);
                job.setSystem(true);
                job.start();
            }
            return false;
        }
        AgentFileViewer fileView = new AgentFileViewer(nodeId, file, followChanges, contextId);
        viewPlacement.openView((View)fileView);
        fileView.viewer.setLineStyler(lineStyler);
        fileView.viewer.showFile(file.getFile(), followChanges);
        if (followChanges) {
            fileView.viewer.startTracking(file.getMonitorId(), nodeId, file.getRemoteName());
        }
        fileView.setName(file.getRemoteName());
        return true;
    }

    static /* synthetic */ NXCSession access$000(AgentFileViewer x0) {
        return x0.session;
    }
}

