/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.AbstractTraceWidget;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.helpers.SyslogLabelProvider;
import org.netxms.nxmc.modules.events.widgets.helpers.SyslogMonitorFilter;
import org.xnap.commons.i18n.I18n;

public class SyslogTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_FACILITY = 3;
    public static final int COLUMN_HOSTNAME = 4;
    public static final int COLUMN_TAG = 5;
    public static final int COLUMN_MESSAGE = 6;
    private I18n i18n;
    private NXCSession session = Registry.getSession();
    private Action actionShowColor;
    private Action actionShowIcons;
    private SyslogLabelProvider labelProvider;

    public SyslogTraceWidget(Composite parent, int style, View view) {
        super(parent, style, view);
        this.session.addListener((SessionListener)this);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setupLocalization() {
        this.i18n = LocalizationHelper.getI18n(SyslogTraceWidget.class);
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new SyslogLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        PreferenceStore ps = PreferenceStore.getInstance();
        this.labelProvider.setShowColor(ps.getAsBoolean("SyslogMonitor.showColor", this.labelProvider.isShowColor()));
        this.labelProvider.setShowIcons(ps.getAsBoolean("SyslogMonitor.showIcons", this.labelProvider.isShowIcons()));
        this.addColumn(this.i18n.tr("Timestamp"), 150);
        this.addColumn(this.i18n.tr("Source"), 200);
        this.addColumn(this.i18n.tr("Severity"), 90);
        this.addColumn(this.i18n.tr("Facility"), 90);
        this.addColumn(this.i18n.tr("Host name"), 130);
        this.addColumn(this.i18n.tr("Tag"), 90);
        this.addColumn(this.i18n.tr("Message"), 600);
    }

    protected AbstractTraceViewFilter createFilter() {
        return new SyslogMonitorFilter();
    }

    protected String getConfigPrefix() {
        return "SyslogMonitor";
    }

    protected void saveConfig() {
        super.saveConfig();
        PreferenceStore ps = PreferenceStore.getInstance();
        ps.set("SyslogMonitor.showColor", this.labelProvider.isShowColor());
        ps.set("SyslogMonitor.showIcons", this.labelProvider.isShowIcons());
    }

    protected void createActions() {
        super.createActions();
        this.actionShowColor = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowIcons = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 7) {
            this.runInUIThread(() -> this.addElement(n.getObject()));
        }
    }

    public Action getActionShowColor() {
        return this.actionShowColor;
    }

    public Action getActionShowIcons() {
        return this.actionShowIcons;
    }
}

