/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectDetailsConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class ObjectDetailsQuery
extends DashboardElementPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectDetailsQuery.class);
    private ObjectDetailsConfig config;
    private TitleConfigurator title;
    private ScriptEditor query;
    private ObjectSelector rootObject;
    private LabeledText orderingProperties;
    private LabeledSpinner refreshInterval;
    private LabeledSpinner recordLimit;

    public ObjectDetailsQuery(DashboardElementConfig elementConfig) {
        super(LocalizationHelper.getI18n(ObjectDetailsQuery.class).tr("Query"), elementConfig);
    }

    public String getId() {
        return "query";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof ObjectDetailsConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (ObjectDetailsConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Query"));
        this.query = new ScriptEditor(dialogArea, 2048, 770, true);
        this.query.setText(this.config.getQuery());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 300;
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.query.setLayoutData((Object)gd);
        this.rootObject = new ObjectSelector(dialogArea, 0, true, true);
        this.rootObject.setLabel(this.i18n.tr("Root object"));
        this.rootObject.setObjectClass(AbstractObject.class);
        this.rootObject.setObjectId(this.config.getRootObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.rootObject.setLayoutData((Object)gd);
        this.orderingProperties = new LabeledText(dialogArea, 0);
        this.orderingProperties.setLabel(this.i18n.tr("Order by"));
        this.orderingProperties.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.orderingProperties.setText(this.config.getOrderingPropertiesAsText());
        this.refreshInterval = new LabeledSpinner(dialogArea, 0);
        this.refreshInterval.setLabel(this.i18n.tr("Refresh interval (seconds)"));
        this.refreshInterval.setRange(1, 100000);
        this.refreshInterval.setSelection(this.config.getRefreshRate());
        this.refreshInterval.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.recordLimit = new LabeledSpinner(dialogArea, 0);
        this.recordLimit.setLabel(this.i18n.tr("Record limit (0 to disable)"));
        this.recordLimit.setRange(0, 10000);
        this.recordLimit.setSelection(this.config.getRecordLimit());
        this.recordLimit.setLayoutData((Object)new GridData(4, 1024, false, false));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setQuery(this.query.getText());
        this.config.setRootObjectId(this.rootObject.getObjectId());
        this.config.setRefreshRate(this.refreshInterval.getSelection());
        this.config.setOrderingProperties(this.orderingProperties.getText().trim());
        this.config.setRecordLimit(this.recordLimit.getSelection());
        return true;
    }
}

