/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventInfo;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class EventTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = Registry.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((int)((EventInfo)element).getSeverity());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return StatusDisplayInfo.getStatusText((int)((EventInfo)element).getSeverity());
            }
            case 1: {
                AbstractObject o = this.session.findObjectById(((EventInfo)element).getSourceObjectId());
                return o != null ? o.getObjectName() : "[" + ((EventInfo)element).getSourceObjectId() + "]";
            }
            case 2: {
                return ((EventInfo)element).getName();
            }
            case 3: {
                return ((EventInfo)element).getMessage();
            }
            case 4: {
                return DateFormatFactory.getDateTimeFormat().format(((EventInfo)element).getTimeStamp());
            }
        }
        return null;
    }
}

