/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.model.ContributionComparator;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.ApplicationWorkbenchWindowAdvisor;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.ExtendedContributionComparator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.TweakletManager;
import org.netxms.ui.eclipse.console.dialogs.SelectPerspectiveDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.PerspectiveSwitcher;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        String p = BrandingManager.getInstance().getDefaultPerspective();
        if (p != null) {
            return p;
        }
        return Activator.getDefault().getPreferenceStore().getString("INITIAL_PERSPECTIVE");
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        PlatformUI.getWorkbench().getProgressService();
        TweakletManager.initTweaklets();
        BrandingManager.create();
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        configurer.setSaveAndRestore(ps.getBoolean("SAVE_AND_RESTORE"));
        if (ps.getBoolean("HTTP_PROXY_ENABLED")) {
            System.setProperty("http.proxyHost", ps.getString("HTTP_PROXY_SERVER"));
            System.setProperty("http.proxyPort", ps.getString("HTTP_PROXY_PORT"));
            System.setProperty("http.noProxyHosts", ps.getString("HTTP_PROXY_EXCLUSIONS"));
            System.setProperty("https.proxyHost", ps.getString("HTTP_PROXY_SERVER"));
            System.setProperty("https.proxyPort", ps.getString("HTTP_PROXY_PORT"));
            System.setProperty("https.noProxyHosts", ps.getString("HTTP_PROXY_EXCLUSIONS"));
            if (ps.getBoolean("HTTP_PROXY_AUTH")) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(ps.getString("HTTP_PROXY_LOGIN"), ps.getString("HTTP_PROXY_PASSWORD").toCharArray());
                    }
                });
            }
        } else {
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            System.clearProperty("http.noProxyHosts");
            System.clearProperty("https.proxyHost");
            System.clearProperty("https.proxyPort");
            System.clearProperty("https.noProxyHosts");
        }
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){
            private Set<IWorkbenchWindow> windows = new HashSet<IWorkbenchWindow>();

            public void windowOpened(final IWorkbenchWindow window) {
                NXCSession session = ConsoleSharedData.getSession();
                if (!this.windows.contains(window) && session.getClientConfigurationHintAsBoolean("PerspectiveSwitcher.Enable", true)) {
                    new PerspectiveSwitcher(window);
                    this.windows.add(window);
                }
                if (session.getClientConfigurationHintAsBoolean("PerspectiveSwitcher.Enable", true) && session.getClientConfigurationHintAsBoolean("PerspectiveSwitcher.ShowOnStartup", false)) {
                    new UIJob("Select perspective"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            SelectPerspectiveDialog dlg;
                            IPerspectiveDescriptor currPerspective = window.getActivePage().getPerspective();
                            IPerspectiveDescriptor p = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.netxms.ui.eclipse.console.SwitcherPerspective");
                            if (p != null) {
                                window.getActivePage().setPerspective(p);
                            }
                            if ((dlg = new SelectPerspectiveDialog(null)).open() == 0) {
                                window.getActivePage().setPerspective(dlg.getSelectedPerspective());
                            } else {
                                window.getActivePage().setPerspective(currPerspective);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                this.windows.remove(window);
            }

            public void windowActivated(IWorkbenchWindow window) {
                NXCSession session = ConsoleSharedData.getSession();
                if (!this.windows.contains(window) && session.getClientConfigurationHintAsBoolean("PerspectiveSwitcher.Enable", true)) {
                    new PerspectiveSwitcher(window);
                    this.windows.add(window);
                }
            }
        });
    }

    public ContributionComparator getComparatorFor(String contributionType) {
        if (contributionType.equals("property")) {
            return new ExtendedContributionComparator();
        }
        return super.getComparatorFor(contributionType);
    }

    public void postStartup() {
        super.postStartup();
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                if (Activator.getDefault().getPreferenceStore().getBoolean("HIDE_WHEN_MINIMIZED")) {
                    shell.setVisible(false);
                }
            }
        });
        NXCSession session = ConsoleSharedData.getSession();
        session.addListener(new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 1 || n.getCode() == 1001 || n.getCode() == 1027) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String string;
                            String productName = BrandingManager.getInstance().getProductName();
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            Messages.get();
                            if (n.getCode() == 1) {
                                Messages.get();
                                string = String.format(Messages.ApplicationWorkbenchAdvisor_ConnectionLostMessage, productName);
                            } else if (n.getCode() == 1027) {
                                Messages.get();
                                string = Messages.ApplicationWorkbenchAdvisor_SessionTerminated;
                            } else {
                                Messages.get();
                                string = String.format(Messages.ApplicationWorkbenchAdvisor_ServerShutdownMessage, productName);
                            }
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(string));
                            Messages.get();
                            MessageDialog.openError((Shell)shell, (String)Messages.ApplicationWorkbenchAdvisor_CommunicationError, (String)stringBuilder.append(Messages.ApplicationWorkbenchAdvisor_OKToCloseMessage).toString());
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().close();
                        }
                    });
                }
            }
        });
    }
}

