/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.SensorDeviceClass;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Sensor;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledCombo;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SensorProperties
extends PropertyPage {
    private Sensor sensor;
    private LabeledCombo deviceClass;
    private ObjectSelector gatewayNode;
    private LabeledText macAddress;
    private LabeledText deviceAddress;
    private LabeledSpinner modbusUnitId;
    private LabeledText vendor;
    private LabeledText model;
    private LabeledText serialNumber;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.sensor = (Sensor)this.getElement().getAdapter(Sensor.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.deviceClass = new LabeledCombo(dialogArea, 0);
        this.deviceClass.setLabel("Device class");
        this.deviceClass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Locale locale = Locale.getDefault();
        SensorDeviceClass[] sensorDeviceClassArray = (SensorDeviceClass[])SensorDeviceClass.class.getEnumConstants();
        int n = sensorDeviceClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SensorDeviceClass c = sensorDeviceClassArray[n2];
            this.deviceClass.add(c.getDisplayName(locale));
            ++n2;
        }
        this.deviceClass.select(this.sensor.getDeviceClass().getValue());
        this.gatewayNode = new ObjectSelector(dialogArea, 0, true);
        this.gatewayNode.setLabel("Gateway node");
        this.gatewayNode.setObjectClass(Node.class);
        this.gatewayNode.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        this.gatewayNode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.gatewayNode.setObjectId(this.sensor.getGatewayId());
        this.macAddress = new LabeledText(dialogArea, 0);
        this.macAddress.setLabel("MAC address");
        this.macAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.macAddress.setText(this.sensor.getMacAddress().toString());
        this.modbusUnitId = new LabeledSpinner(dialogArea, 0);
        this.modbusUnitId.setLabel("Modbus unit ID");
        this.modbusUnitId.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.modbusUnitId.setRange(0, 255);
        this.modbusUnitId.setSelection((int)this.sensor.getModbusUnitId());
        this.deviceAddress = new LabeledText(dialogArea, 0);
        this.deviceAddress.setLabel("Device address");
        this.deviceAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.deviceAddress.setText(this.sensor.getDeviceAddress());
        this.vendor = new LabeledText(dialogArea, 0);
        this.vendor.setLabel("Vendor");
        this.vendor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.vendor.setText(this.sensor.getVendor());
        this.model = new LabeledText(dialogArea, 0);
        this.model.setLabel("Model");
        this.model.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.model.setText(this.sensor.getModel());
        this.serialNumber = new LabeledText(dialogArea, 0);
        this.serialNumber.setLabel("Serial number");
        this.serialNumber.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.serialNumber.setText(this.sensor.getSerialNumber());
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.sensor.getObjectId());
        String macAddressText = this.macAddress.getText().trim();
        if (!macAddressText.isEmpty()) {
            try {
                md.setMacAddress(MacAddress.parseMacAddress((String)this.macAddress.getText().trim()));
            }
            catch (MacAddressFormatException e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Invalid MAC address");
                return false;
            }
        } else {
            md.setMacAddress(new MacAddress());
        }
        md.setDeviceClass(SensorDeviceClass.getByValue((int)this.deviceClass.getSelectionIndex()));
        md.setVendor(this.vendor.getText().trim());
        md.setModel(this.model.getText().trim());
        md.setSerialNumber(this.serialNumber.getText().trim());
        md.setDeviceAddress(this.deviceAddress.getText().trim());
        md.setModbusUnitId(Short.valueOf((short)this.modbusUnitId.getSelection()));
        md.setSensorProxy(this.gatewayNode.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SensorPolling_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SensorPolling_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SensorProperties.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performDefaults() {
        this.gatewayNode.setObjectId(0L);
        this.deviceClass.select(0);
        this.macAddress.setText("");
        this.deviceAddress.setText("");
        this.modbusUnitId.setSelection(255);
        this.vendor.setText("");
        this.model.setText("");
        this.serialNumber.setText("");
    }
}

