/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.CreateInterfaceDciDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.InterfaceDciInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateInterfraceDci
implements IObjectActionDelegate {
    private static final int IFDCI_IN_BYTES = 0;
    private static final int IFDCI_OUT_BYTES = 1;
    private static final int IFDCI_IN_BITS = 2;
    private static final int IFDCI_OUT_BITS = 3;
    private static final int IFDCI_IN_PACKETS = 4;
    private static final int IFDCI_OUT_PACKETS = 5;
    private static final int IFDCI_IN_ERRORS = 6;
    private static final int IFDCI_OUT_ERRORS = 7;
    private Shell shell;
    private ViewPart viewPart;
    private List<Interface> objects = new ArrayList<Interface>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final CreateInterfaceDciDialog dlg = new CreateInterfaceDciDialog(this.shell, this.objects.size() == 1 ? this.objects.get(0) : null);
        if (dlg.open() != 0) {
            return;
        }
        final ArrayList<Interface> ifaces = new ArrayList<Interface>(this.objects);
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        for (Interface iface : ifaces) {
            AbstractNode node = iface.getParentNode();
            if (node == null) continue;
            nodes.add(node);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        final String taskName = Messages.CreateInterfraceDci_TaskName;
        Messages.get();
        new ConsoleJob(Messages.CreateInterfraceDci_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                InterfaceDciInfo[] dciInfo = dlg.getDciInfo();
                monitor.beginTask(taskName, ifaces.size() * dciInfo.length);
                int i = 0;
                while (i < ifaces.size()) {
                    int j = 0;
                    while (j < dciInfo.length) {
                        if (dciInfo[j].enabled) {
                            CreateInterfraceDci.createInterfaceDci(session, (Interface)ifaces.get(i), j, dciInfo[j], dlg.getPollingScheduleType(), dlg.getPollingInterval(), dlg.getRetentionType(), dlg.getRetentionTime(), ifaces.size() > 1);
                        }
                        monitor.worked(1);
                        ++j;
                    }
                    ++i;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.CreateInterfraceDci_JobError;
            }
        }.start();
    }

    private static void createInterfaceDci(NXCSession session, Interface iface, int dciType, InterfaceDciInfo dciInfo, int pollingScheduleType, int pollingInterval, int retentionType, int retentionTime, boolean updateDescription) throws Exception {
        AbstractNode node = iface.getParentNode();
        if (node == null) {
            throw new NXCException(46);
        }
        DataCollectionConfiguration dcc = new DataCollectionConfiguration(session, node.getObjectId());
        DataCollectionItem dci = new DataCollectionItem(dcc, 0L);
        dci.setPollingScheduleType(pollingScheduleType);
        dci.setPollingInterval(Integer.toString(pollingInterval));
        dci.setRetentionType(retentionType);
        dci.setRetentionTime(Integer.toString(retentionTime));
        if (node.hasAgent()) {
            dci.setOrigin(DataOrigin.AGENT);
            if (node.isAgentIfXCountersSupported()) {
                dci.setDataType(dciType != 6 && dciType != 7 ? DataType.COUNTER64 : DataType.COUNTER32);
            } else {
                dci.setDataType(DataType.COUNTER32);
            }
        } else {
            dci.setOrigin(DataOrigin.SNMP);
            if (node.isIfXTableSupported()) {
                dci.setDataType(dciType != 6 && dciType != 7 ? DataType.COUNTER64 : DataType.COUNTER32);
            } else {
                dci.setDataType(DataType.COUNTER32);
            }
        }
        dci.setStatus(0);
        dci.setDescription(updateDescription ? dciInfo.description.replaceAll("@@ifName@@", iface.getObjectName()) : dciInfo.description);
        dci.setDeltaCalculation(dciInfo.delta ? 2 : 0);
        dci.setRelatedObject(iface.getObjectId());
        if (dci.getOrigin() == DataOrigin.AGENT) {
            switch (dciType) {
                case 0: 
                case 2: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.BytesIn64(" : "Net.Interface.BytesIn(") + iface.getIfIndex() + ")");
                    break;
                }
                case 1: 
                case 3: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.BytesOut64(" : "Net.Interface.BytesOut(") + iface.getIfIndex() + ")");
                    break;
                }
                case 4: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.PacketsIn64(" : "Net.Interface.PacketsIn(") + iface.getIfIndex() + ")");
                    break;
                }
                case 5: {
                    dci.setName(String.valueOf(node.isAgentIfXCountersSupported() ? "Net.Interface.PacketsOut64(" : "Net.Interface.PacketsOut(") + iface.getIfIndex() + ")");
                    break;
                }
                case 6: {
                    dci.setName("Net.Interface.InErrors(" + iface.getIfIndex() + ")");
                    break;
                }
                case 7: {
                    dci.setName("Net.Interface.OutErrors(" + iface.getIfIndex() + ")");
                }
            }
        } else {
            switch (dciType) {
                case 0: 
                case 2: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.6" : ".1.3.6.1.2.1.2.2.1.10") + CreateInterfraceDci.getInterfaceInstance(iface));
                    break;
                }
                case 1: 
                case 3: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.10" : ".1.3.6.1.2.1.2.2.1.16") + CreateInterfraceDci.getInterfaceInstance(iface));
                    break;
                }
                case 4: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.7" : ".1.3.6.1.2.1.2.2.1.11") + CreateInterfraceDci.getInterfaceInstance(iface));
                    break;
                }
                case 5: {
                    dci.setName(String.valueOf(node.isIfXTableSupported() ? ".1.3.6.1.2.1.31.1.1.1.11" : ".1.3.6.1.2.1.2.2.1.17") + CreateInterfraceDci.getInterfaceInstance(iface));
                    break;
                }
                case 6: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.14" + CreateInterfraceDci.getInterfaceInstance(iface));
                    break;
                }
                case 7: {
                    dci.setName(".1.3.6.1.2.1.2.2.1.20" + CreateInterfraceDci.getInterfaceInstance(iface));
                }
            }
        }
        if (dciInfo.delta) {
            switch (dciType) {
                case 2: {
                    dci.setSystemTag("iface-inbound-bits");
                    break;
                }
                case 0: {
                    dci.setSystemTag("iface-inbound-bytes");
                    break;
                }
                case 3: {
                    dci.setSystemTag("iface-outbound-bits");
                    break;
                }
                case 1: {
                    dci.setSystemTag("iface-outbound-bytes");
                }
            }
        }
        switch (dciType) {
            case 0: 
            case 1: {
                dci.setUnitName(dciInfo.delta ? "B/s" : "B (Metric)");
                break;
            }
            case 2: 
            case 3: {
                dci.setUnitName(dciInfo.delta ? "b/s" : "b (Metric)");
                break;
            }
            case 4: 
            case 5: {
                dci.setUnitName(dciInfo.delta ? "packets/s" : "packets");
                break;
            }
            case 6: 
            case 7: {
                dci.setUnitName(dciInfo.delta ? "errors/s" : "errors");
            }
        }
        if (dciType == 2 || dciType == 3) {
            dci.setTransformationScript("return $1 * 8;");
        }
        dcc.modifyObject((DataCollectionObject)dci);
    }

    private static String getInterfaceInstance(Interface iface) {
        return iface.getIfTableSuffix().getLength() > 0 ? iface.getIfTableSuffix().toString() : "." + iface.getIfIndex();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof Interface)) continue;
                this.objects.add((Interface)o);
            }
            action.setEnabled(this.objects.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }
}

