/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RackOrientation {
    FILL(0),
    FRONT(1),
    REAR(2);

    private static Logger logger;
    private static Map<Integer, RackOrientation> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(RackOrientation.class);
        lookupTable = new HashMap<Integer, RackOrientation>();
        RackOrientation[] rackOrientationArray = RackOrientation.values();
        int n = rackOrientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            RackOrientation element = rackOrientationArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private RackOrientation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackOrientation getByValue(int value) {
        RackOrientation element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return FILL;
        }
        return element;
    }
}

