/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.ServerActionType;

public class ServerAction {
    private long id;
    private ServerActionType type;
    private String name;
    private String data;
    private String recipientAddress;
    private String emailSubject;
    private boolean disabled;
    private String channelName;

    public ServerAction(long id) {
        this.id = id;
        this.type = ServerActionType.LOCAL_COMMAND;
        this.name = "New action";
        this.data = "";
        this.disabled = false;
        this.channelName = "";
    }

    public ServerAction(long id, ServerAction src) {
        this.id = id;
        this.type = src.type;
        this.name = src.name;
        this.data = src.data;
        this.recipientAddress = src.recipientAddress;
        this.emailSubject = src.emailSubject;
        this.disabled = src.disabled;
        this.channelName = src.channelName;
    }

    protected ServerAction(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(97L);
        this.type = ServerActionType.getByValue(msg.getFieldAsInt32(99L));
        this.name = msg.getFieldAsString(87L);
        this.data = msg.getFieldAsString(100L);
        this.recipientAddress = msg.getFieldAsString(102L);
        this.emailSubject = msg.getFieldAsString(101L);
        this.disabled = msg.getFieldAsBoolean(98L);
        this.channelName = msg.getFieldAsString(654L);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(97L, (int)this.id);
        msg.setFieldInt16(99L, this.type.getValue());
        msg.setField(87L, this.name);
        msg.setField(100L, this.data);
        msg.setField(102L, this.recipientAddress);
        msg.setField(101L, this.emailSubject);
        msg.setFieldInt16(98L, this.disabled ? 1 : 0);
        msg.setField(654L, this.channelName);
    }

    public ServerActionType getType() {
        return this.type;
    }

    public void setType(ServerActionType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }
}

