/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.views.helpers;

import java.util.Collection;
import java.util.Date;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.modules.users.views.helpers.BaseUserLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class LogLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(LogLabelProvider.class);
    private final String[] ALARM_STATE_TEXTS = LogLabelProvider.getAlarmStateTexts((I18n)this.i18n);
    private final String[] ALARM_HD_STATE_TEXTS = LogLabelProvider.getAlarmHDStateTexts((I18n)this.i18n);
    private final String[] EVENT_ORIGIN_TEXTS = LogLabelProvider.getEventOriginTexts((I18n)this.i18n);
    private final String[] ASSET_OPERATION_TEXTS = LogLabelProvider.getAssetOperationTexts((I18n)this.i18n);
    private LogColumn[] columns;
    private NXCSession session;
    private Image[] alarmStateImages;
    private BaseObjectLabelProvider objectLabelProvider;
    private BaseUserLabelProvider userLabelProvider;
    private TableViewer viewer;

    public LogLabelProvider(Log logHandle, TableViewer viewer) {
        this.viewer = viewer;
        Collection c = logHandle.getColumns();
        this.columns = c.toArray(new LogColumn[c.size()]);
        this.session = Registry.getSession();
        this.alarmStateImages = new Image[4];
        this.alarmStateImages[0] = ResourceManager.getImage((String)"icons/alarms/outstanding.png");
        this.alarmStateImages[1] = ResourceManager.getImage((String)"icons/alarms/acknowledged.png");
        this.alarmStateImages[2] = ResourceManager.getImage((String)"icons/alarms/resolved.png");
        this.alarmStateImages[3] = ResourceManager.getImage((String)"icons/alarms/terminated.png");
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.userLabelProvider = new BaseUserLabelProvider();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        String value = ((TableRow)element).get(columnIndex).getValue();
        switch (this.columns[columnIndex].getType()) {
            case 7: {
                try {
                    int state = Integer.parseInt(value);
                    return this.alarmStateImages[state & 0xF];
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    long id = Long.parseLong(value);
                    AbstractObject object = this.session.findObjectById(id);
                    return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 1: {
                try {
                    int severity = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusImage((int)severity);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 13: {
                try {
                    int status = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusImage((int)(status > 0 ? ObjectStatus.NORMAL.getValue() : ObjectStatus.MAJOR.getValue()));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 3: {
                try {
                    int id = Integer.parseInt(value);
                    AbstractUserObject user = this.session.findUserDBObjectById(id, (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                    return user != null ? this.userLabelProvider.getImage((Object)user) : null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = ((TableRow)element).get(columnIndex).getValue();
        switch (this.columns[columnIndex].getType()) {
            case 8: {
                try {
                    int state = Integer.parseInt(value);
                    return this.ALARM_HD_STATE_TEXTS[state];
                }
                catch (Exception e) {
                    return this.i18n.tr("<error>");
                }
            }
            case 7: {
                try {
                    int state = Integer.parseInt(value);
                    return this.ALARM_STATE_TEXTS[state & 0xF];
                }
                catch (Exception e) {
                    return this.i18n.tr("<error>");
                }
            }
            case 4: {
                try {
                    return this.session.getEventName(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 10: {
                try {
                    int origin = Integer.parseInt(value);
                    return this.EVENT_ORIGIN_TEXTS[origin];
                }
                catch (Exception e) {
                    return value;
                }
            }
            case 2: {
                try {
                    long id = Long.parseLong(value);
                    return id != 0L ? this.session.getObjectName(id) : "";
                }
                catch (NumberFormatException e) {
                    return this.i18n.tr("<error>");
                }
            }
            case 1: {
                try {
                    int severity = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusText((int)severity);
                }
                catch (NumberFormatException e) {
                    return this.i18n.tr("<error>");
                }
            }
            case 13: {
                try {
                    int status = Integer.parseInt(value);
                    return status > 0 ? "Success" : "Failure";
                }
                catch (NumberFormatException e) {
                    return this.i18n.tr("<error>");
                }
            }
            case 5: {
                try {
                    long timestamp = Long.parseLong(value);
                    Date date = new Date(timestamp * 1000L);
                    return DateFormatFactory.getDateTimeFormat().format(date);
                }
                catch (NumberFormatException e) {
                    return this.i18n.tr("<error>");
                }
            }
            case 3: {
                try {
                    int id = Integer.parseInt(value);
                    AbstractUserObject user = this.session.findUserDBObjectById(id, (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                    return user != null ? this.userLabelProvider.getText((Object)user) : null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 9: {
                try {
                    int uin = Integer.parseInt(value);
                    Zone zone = this.session.findZone(uin);
                    return zone != null ? zone.getObjectName() : "[" + uin + "]";
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 16: {
                try {
                    int operation = Integer.parseInt(value);
                    return this.ASSET_OPERATION_TEXTS[operation];
                }
                catch (Exception e) {
                    return value;
                }
            }
        }
        return value;
    }

    public void dispose() {
        for (int i = 0; i < this.alarmStateImages.length; ++i) {
            if (this.alarmStateImages[i] == null) continue;
            this.alarmStateImages[i].dispose();
        }
        this.objectLabelProvider.dispose();
        this.userLabelProvider.dispose();
    }

    public static final String[] getAlarmStateTexts(I18n i18n) {
        if (i18n == null) {
            i18n = LocalizationHelper.getI18n(LogLabelProvider.class);
        }
        return new String[]{i18n.tr("Outstanding"), i18n.tr("Acknowledged"), i18n.tr("Resolved"), i18n.tr("Terminated")};
    }

    public static final String[] getAlarmHDStateTexts(I18n i18n) {
        if (i18n == null) {
            i18n = LocalizationHelper.getI18n(LogLabelProvider.class);
        }
        return new String[]{i18n.tr("Ignored"), i18n.tr("Open"), i18n.tr("Closed")};
    }

    public static final String[] getEventOriginTexts(I18n i18n) {
        if (i18n == null) {
            i18n = LocalizationHelper.getI18n(LogLabelProvider.class);
        }
        return new String[]{i18n.tr("System"), i18n.tr("Agent"), i18n.tr("Client"), i18n.tr("Syslog"), i18n.tr("SNMP"), i18n.tr("Script"), i18n.tr("Remote Server"), i18n.tr("Windows Event")};
    }

    public static final String[] getAssetOperationTexts(I18n i18n) {
        if (i18n == null) {
            i18n = LocalizationHelper.getI18n(LogLabelProvider.class);
        }
        return new String[]{i18n.tr("Create"), i18n.tr("Delete"), i18n.tr("Update"), i18n.tr("Link"), i18n.tr("Unlink")};
    }
}

