/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectDciDialog;
import org.xnap.commons.i18n.I18n;

public class DciSelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(DciSelector.class);
    private long nodeId = 0L;
    private long dciId = 0L;
    private String emptySelectionName = this.i18n.tr("<none>");
    private NXCSession session = Registry.getSession();
    private int dcObjectType = -1;
    private int dciObjectType = -1;
    private String dciName = null;
    private boolean fixedNode = false;
    private boolean allowNoValueObjects = false;

    public DciSelector(Composite parent, int style) {
        this(parent, style, false);
    }

    public DciSelector(Composite parent, int style, boolean showContextButton) {
        super(parent, style, new SelectorConfigurator().setShowContextButton(showContextButton));
        this.setText(this.emptySelectionName);
        this.session = Registry.getSession();
    }

    protected void selectionButtonHandler() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), this.fixedNode ? this.nodeId : 0L);
        dlg.setEnableEmptySelection(true);
        dlg.setDcObjectType(this.dcObjectType);
        dlg.setSingleSelection(true);
        dlg.setAllowNoValueObjects(this.allowNoValueObjects);
        if (dlg.open() == 0) {
            List dci = dlg.getSelection();
            if (dci != null && dci.size() == 1) {
                this.setDciId(((DciValue)dci.get(0)).getNodeId(), ((DciValue)dci.get(0)).getId());
                this.dciName = ((DciValue)dci.get(0)).getName();
                this.dciObjectType = ((DciValue)dci.get(0)).getDcObjectType();
            } else {
                this.setDciId(this.fixedNode ? this.nodeId : 0L, 0L);
                this.dciName = null;
            }
            this.fireModifyListeners();
        }
    }

    protected void contextButtonHandler() {
        this.setDciId(0xFFFFFFFFL, 0L);
        this.dciName = null;
        this.fireModifyListeners();
    }

    private void updateText() {
        if (this.nodeId == 0xFFFFFFFFL) {
            this.setText(this.i18n.tr("<context>"));
            return;
        }
        if (this.nodeId == 0L || this.dciId == 0L) {
            this.setText(this.emptySelectionName);
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long nodeId, long dciId) {
        this.nodeId = nodeId;
        this.dciId = dciId;
        this.updateText();
    }

    public String getEmptySelectionName() {
        return this.emptySelectionName;
    }

    public void setEmptySelectionName(String emptySelectionName) {
        this.emptySelectionName = emptySelectionName;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
    }

    public final boolean isFixedNode() {
        return this.fixedNode;
    }

    public final void setFixedNode(boolean fixedNode) {
        this.fixedNode = fixedNode;
    }

    public final String getDciName() {
        return this.dciName;
    }

    public final String getDciToolTipInfo() {
        return this.getText();
    }

    public int getDciObjectType() {
        return this.dciObjectType;
    }

    public void setDciObjectType(int dciObjectType) {
        this.dciObjectType = dciObjectType;
    }

    public void setAllowNoValueObjects(boolean allowNoValueObjects) {
        this.allowNoValueObjects = allowNoValueObjects;
    }

    public boolean isAllowNoValueObjects() {
        return this.allowNoValueObjects;
    }

    static /* synthetic */ void access$000(DciSelector x0, String x1) {
        x0.setText(x1);
    }
}

