/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentPolicy;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.LocalChangeListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.CreatePolicyDialog;
import org.netxms.nxmc.modules.datacollection.views.PolicyEditorView;
import org.netxms.nxmc.modules.datacollection.views.PolicyListView;
import org.netxms.nxmc.modules.datacollection.views.helpers.PolicyComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.PolicyFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.PolicyLabelProvider;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class PolicyListView
extends ObjectView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(PolicyListView.class);
    public static final String JOB_FAMILY = "PolicyEditorJob";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_GUID = 2;
    private Display display;
    private NXCSession session = Registry.getSession();
    private HashMap<UUID, AgentPolicy> policies = null;
    private PolicyFilter filter;
    private SortableTableViewer policyList;
    private Action actionCreate;
    private Action actionDelete;
    private Action actionEdit;
    private Action actionRename;
    private Action actionCopy;
    private Action actionMove;
    private Action actionDuplicate;
    private Action actionForceDeploy;

    public PolicyListView() {
        super(LocalizationHelper.getI18n(PolicyListView.class).tr("Agent Policies"), ResourceManager.getImageDescriptor((String)"icons/object-views/policy.gif"), "AgentPolicies", true);
    }

    protected void createContent(Composite parent) {
        this.display = this.getWindow().getShell().getDisplay();
        String[] names = new String[]{this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("GUID")};
        int[] widths = new int[]{250, 200, 100};
        this.policyList = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.policyList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.policyList.setLabelProvider((IBaseLabelProvider)new PolicyLabelProvider());
        this.policyList.setComparator((ViewerComparator)new PolicyComparator());
        this.filter = new PolicyFilter();
        this.policyList.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.policyList, (String)"PolicyEditorView");
        this.policyList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.policyList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.policyList.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    protected void onObjectChange(AbstractObject object) {
        this.applyPolicy();
        this.refresh();
    }

    public void refresh() {
        if (!this.isActive()) {
            return;
        }
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    protected void createActions() {
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRename = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionMove = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMove.setEnabled(false);
        this.actionDuplicate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDuplicate.setEnabled(false);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.actionForceDeploy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionForceDeploy.setEnabled(false);
    }

    protected void renamePolicy() {
        IStructuredSelection selection = this.policyList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentPolicy policy = (AgentPolicy)selection.getFirstElement();
        CreatePolicyDialog dlg = new CreatePolicyDialog(this.getWindow().getShell(), policy);
        if (dlg.open() != 0) {
            return;
        }
        AgentPolicy newPolicy = dlg.getPolicy();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void copyPolicies(boolean doMove) {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createTemplateSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        if (dlg.getSelectedObjects(Template.class).length <= 0) {
            MessageDialogHelper.openError((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Please select at least one destination template."));
            return;
        }
        IStructuredSelection selection = this.policyList.getStructuredSelection();
        Iterator it = selection.iterator();
        AgentPolicy[] policyList = new AgentPolicy[selection.size()];
        for (int i = 0; i < policyList.length && it.hasNext(); ++i) {
            policyList[i] = (AgentPolicy)it.next();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void duplicatePolicies() {
        IStructuredSelection selection = this.policyList.getStructuredSelection();
        Iterator it = selection.iterator();
        AgentPolicy[] policyList = new AgentPolicy[selection.size()];
        for (int i = 0; i < policyList.length && it.hasNext(); ++i) {
            policyList[i] = new AgentPolicy((AgentPolicy)it.next());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editPolicy() {
        IStructuredSelection selection = this.policyList.getStructuredSelection();
        AgentPolicy policy = (AgentPolicy)selection.getFirstElement();
        this.openView((View)new PolicyEditorView(policy.getGuid(), this.getObjectId(), (LocalChangeListener)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected void deletePolicy() {
        IStructuredSelection selection = this.policyList.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete policy"), (String)this.i18n.tr("Do you really want to delete selected policies?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void createNewPolicy() {
        CreatePolicyDialog dlg = new CreatePolicyDialog(this.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        AgentPolicy newPolicy = dlg.getPolicy();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void forceDeploy() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.policyList.getControl());
        this.policyList.getControl().setMenu(menu);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionForceDeploy);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IAction)this.actionForceDeploy);
        manager.add((IContributionItem)new Separator());
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1039: {
                if (n.getSubCode() != this.getObjectId()) {
                    return;
                }
                this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1040: {
                if (n.getSubCode() != this.getObjectId()) {
                    return;
                }
                this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void applyPolicy() {
        if (this.getObjectId() == 0L) {
            return;
        }
        23 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void dispose() {
        this.applyPolicy();
        super.dispose();
    }

    public void showInformationMessage() {
        this.addMessage(0, this.i18n.tr("Changes in policies have been made. Please deploy them to nodes"), false, "Deploy policies", (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.actionForceDeploy.setEnabled(true);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Template;
    }
}

