/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.RemoteChangeListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.ShowHistoricalDataMenuItems;
import org.netxms.nxmc.modules.datacollection.dialogs.BulkUpdateDialog;
import org.netxms.nxmc.modules.datacollection.dialogs.helpers.BulkDciUpdateElementUI;
import org.netxms.nxmc.modules.datacollection.views.BaseDataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.DataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.helpers.DciComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.DciFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.DciLabelProvider;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.DialogData;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.VisibilityValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class DataCollectionView
extends BaseDataCollectionView {
    private static final Logger logger = LoggerFactory.getLogger(DataCollectionView.class);
    private final I18n i18n = LocalizationHelper.getI18n(DataCollectionView.class);
    public static final int DC_COLUMN_ID = 0;
    public static final int DC_COLUMN_DESCRIPTION = 1;
    public static final int DC_COLUMN_ORIGIN = 2;
    public static final int DC_COLUMN_PARAMETER = 3;
    public static final int DC_COLUMN_DATAUNIT = 4;
    public static final int DC_COLUMN_DATATYPE = 5;
    public static final int DC_COLUMN_INTERVAL = 6;
    public static final int DC_COLUMN_RETENTION = 7;
    public static final int DC_COLUMN_STATUS = 8;
    public static final int DC_COLUMN_THRESHOLD = 9;
    public static final int DC_COLUMN_TEMPLATE = 10;
    public static final int DC_COLUMN_RELATEDOBJ = 11;
    public static final int DC_COLUMN_STATUSCALC = 12;
    private boolean editMode = false;
    private Composite parent;
    private SessionListener clientListener = null;
    private DataCollectionConfiguration dciConfig = null;
    private int messageId = 0;
    private DciFilter dcFilter;
    private boolean hideModificationWarnings;
    private RemoteChangeListener changeListener;
    private Action actionToggleEditMode;
    private Action actionCreateItem;
    private Action actionCreateTable;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionCopy;
    private Action actionMove;
    private Action actionConvert;
    private Action actionDuplicate;
    private Action actionActivate;
    private Action actionDisable;
    private Action actionBulkUpdate;
    private Action actionHideTemplateItems;
    private Action actionApplyChanges;
    private Action actionShowTemplate;

    public DataCollectionView() {
        super("objects.data-collection", true);
    }

    public View cloneView() {
        DataCollectionView view = (DataCollectionView)super.cloneView();
        view.editMode = this.editMode;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        if (this.editMode && this.dciConfig != null) {
            this.dciConfig.setUserData((Object)this.viewer);
            this.dciConfig.setRemoteChangeListener(this.changeListener);
        }
    }

    protected void createContent(Composite parent) {
        this.parent = parent;
        1 validator = new /* Unavailable Anonymous Inner Class!! */;
        if (this.editMode) {
            this.createDataCollectionViewer(parent);
        } else {
            this.createLastValuesViewer(parent, (VisibilityValidator)validator);
        }
        this.createActions();
    }

    private void createDataCollectionViewer(Composite parent) {
        String configPrefix = "DataCollectionConfiguration";
        PreferenceStore ds = PreferenceStore.getInstance();
        parent.setLayout((Layout)new FillLayout());
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Display name"), this.i18n.tr("Origin"), this.i18n.tr("Metric"), this.i18n.tr("Units"), this.i18n.tr("Data Type"), this.i18n.tr("Polling Interval"), this.i18n.tr("Retention Time"), this.i18n.tr("Status"), this.i18n.tr("Thresholds"), this.i18n.tr("Template"), this.i18n.tr("Related Object"), this.i18n.tr("Is status calculation")};
        int[] widths = new int[]{60, 250, 150, 200, 90, 90, 90, 90, 100, 200, 150, 150, 90};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DciComparator((DciLabelProvider)this.viewer.getLabelProvider()));
        this.dcFilter = new DciFilter();
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.dcFilter);
        this.dcFilter.setHideTemplateItems(ds.getAsBoolean(configPrefix + ".hideTemplateItems", false));
        this.viewer.addFilter((ViewerFilter)this.dcFilter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createContextMenu();
        this.hideModificationWarnings = ds.getAsBoolean(configPrefix + ".hideModificationWarnings", false);
        Display display = this.viewer.getControl().getDisplay();
        this.changeListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    void updateItems() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        this.viewer.setInput((Object)this.dciConfig.getItems());
        ArrayList<DataCollectionObject> selected = new ArrayList<DataCollectionObject>(selection.size());
        block0: for (DataCollectionObject obj : selection) {
            for (DataCollectionObject item : (DataCollectionObject[])this.viewer.getInput()) {
                if (obj.getId() != item.getId()) continue;
                selected.add(item);
                continue block0;
            }
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(selected.toArray()));
    }

    protected void postLastValueViewCreation(String configPrefix, VisibilityValidator validator) {
        super.postLastValueViewCreation(configPrefix, validator);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        Display display = this.viewer.getControl().getDisplay();
        this.clientListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.clientListener);
    }

    protected void fillContextMenu(IMenuManager manager) {
        boolean isTemplate = this.getObject() instanceof Template;
        int selectionType = this.getDciSelectionType();
        if (!isTemplate) {
            ShowHistoricalDataMenuItems.populateMenu((IMenuManager)manager, (View)this, (AbstractObject)this.getObject(), (StructuredViewer)this.viewer, (int)selectionType);
        }
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionCreateTable);
        if (this.actionActivate.isEnabled()) {
            manager.add((IAction)this.actionActivate);
        }
        if (this.actionDisable.isEnabled()) {
            manager.add((IAction)this.actionDisable);
        }
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionBulkUpdate);
        manager.add((IAction)this.actionDuplicate);
        manager.add((IAction)this.actionDelete);
        MenuManager moveOrCopy = new MenuManager(this.i18n.tr("Move or Copy"));
        moveOrCopy.add((IAction)this.actionCopy);
        moveOrCopy.add((IAction)this.actionMove);
        if (!isTemplate) {
            moveOrCopy.add((IAction)this.actionConvert);
        }
        manager.add((IContributionItem)moveOrCopy);
        manager.add((IContributionItem)new Separator());
        MenuManager export = new MenuManager(this.i18n.tr("E&xport"));
        export.add((IAction)this.actionExportToCsv);
        export.add((IAction)this.actionExportAllToCsv);
        export.add((IAction)this.actionCopyToClipboard);
        export.add((IAction)this.actionCopyDciName);
        if (!this.editMode) {
            export.add((IAction)this.actionCopyValuesToClipboard);
        }
        manager.add((IContributionItem)export);
        MenuManager actions = new MenuManager(this.i18n.tr("A&ctions"));
        actions.add((IAction)this.actionForcePoll);
        actions.add((IAction)this.actionRecalculateData);
        actions.add((IAction)this.actionClearData);
        manager.add((IContributionItem)actions);
        MenuManager viewOptions = new MenuManager(this.i18n.tr("V&iew options"));
        if (this.editMode) {
            if (!isTemplate) {
                viewOptions.add((IAction)this.actionHideTemplateItems);
            }
        } else {
            viewOptions.add((IAction)this.actionUseMultipliers);
            viewOptions.add((IAction)this.actionShowErrors);
            viewOptions.add((IAction)this.actionShowDisabled);
            viewOptions.add((IAction)this.actionShowUnsupported);
            viewOptions.add((IAction)this.actionShowHidden);
        }
        manager.add((IContributionItem)viewOptions);
        if (!isTemplate) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowTemplate);
        }
    }

    protected void createActions() {
        super.createActions();
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setEnabled(false);
        this.addKeyBinding("M1+E", (IAction)this.actionEdit);
        this.actionBulkUpdate = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+B", (IAction)this.actionBulkUpdate);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionMove = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMove.setEnabled(false);
        this.actionConvert = new /* Unavailable Anonymous Inner Class!! */;
        this.actionConvert.setEnabled(false);
        this.actionDuplicate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDuplicate.setEnabled(false);
        this.actionActivate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionActivate.setEnabled(false);
        this.actionDisable = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDisable.setEnabled(false);
        this.actionCreateItem = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionCreateItem);
        this.actionCreateTable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M2+N", (IAction)this.actionCreateTable);
        this.actionToggleEditMode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionToggleEditMode.setChecked(this.editMode);
        this.addKeyBinding("M1+M", (IAction)this.actionToggleEditMode);
        this.actionHideTemplateItems = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideTemplateItems.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/ignore-template-objects.png"));
        this.actionHideTemplateItems.setChecked(PreferenceStore.getInstance().getAsBoolean("DataCollectionConfiguration.hideTemplateItems", false));
        this.addKeyBinding("M1+M2+T", (IAction)this.actionHideTemplateItems);
        this.actionApplyChanges = new /* Unavailable Anonymous Inner Class!! */;
        this.actionApplyChanges.setEnabled(false);
        this.addKeyBinding("M1+S", (IAction)this.actionApplyChanges);
        this.actionShowTemplate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDisable.setEnabled(false);
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(Runnable callback) {
        if (this.editMode) {
            if (this.dciConfig != null) {
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
        } else {
            this.getDataFromServer(callback);
        }
    }

    protected long getDciId(Object dci) {
        return this.editMode ? ((DataCollectionObject)dci).getId() : ((DciValue)dci).getId();
    }

    protected long getObjectId(Object dci) {
        return this.editMode ? ((DataCollectionObject)dci).getNodeId() : ((DciValue)dci).getNodeId();
    }

    protected String getDciName(Object dci) {
        return this.editMode ? ((DataCollectionObject)dci).getName() : ((DciValue)dci).getName();
    }

    protected DataCollectionObject getDataCollectionObject(Object dci) {
        DataCollectionObject dco;
        if (this.editMode) {
            dco = (DataCollectionObject)dci;
        } else {
            DciValue value = (DciValue)dci;
            dco = this.dciConfig.findItem(value.getId());
        }
        return dco;
    }

    private void showTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DataCollectionObject dco = this.getDataCollectionObject(selection.getFirstElement());
        MainWindow.switchToObject((long)dco.getTemplateId(), (long)dco.getTemplateItemId());
    }

    private void createItem() {
        DataCollectionItem dci = new DataCollectionItem(this.dciConfig, 0L);
        AbstractObject object = this.getObject();
        if (object instanceof AbstractNode && !((AbstractNode)object).hasAgent()) {
            if (((AbstractNode)object).hasSnmpAgent()) {
                dci.setOrigin(DataOrigin.SNMP);
            } else {
                dci.setOrigin(DataOrigin.INTERNAL);
            }
        }
        this.showDCIPropertyPages((DataCollectionObject)dci);
    }

    private void createTable() {
        DataCollectionTable dci = new DataCollectionTable(this.dciConfig, 0L);
        AbstractObject object = this.getObject();
        if (object instanceof AbstractNode && !((AbstractNode)object).hasAgent()) {
            if (((AbstractNode)object).hasSnmpAgent()) {
                dci.setOrigin(DataOrigin.SNMP);
            } else {
                dci.setOrigin(DataOrigin.INTERNAL);
            }
        }
        this.showDCIPropertyPages((DataCollectionObject)dci);
    }

    private void setItemStatus(int newStatus) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteItems() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Data Collection Items"), (String)this.i18n.tr("Do you really want to delete selected data collection items?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void editSelectedObject() {
        String message;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DataCollectionObject dco = this.getDataCollectionObject(selection.getFirstElement());
        DialogData data = null;
        if (!this.hideModificationWarnings && dco.getTemplateId() != 0L && (message = DataCollectionObjectEditor.createModificationWarningMessage((DataCollectionObject)dco)) != null) {
            data = MessageDialogHelper.openWarningWithCheckbox((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Don't show this message again"), (String)message);
            this.hideModificationWarnings = data.getSaveSelection();
        }
        if (data == null || data.isOkPressed()) {
            this.showDCIPropertyPages(dco);
        }
    }

    private void duplicateItems() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        long[] dciList = new long[selection.size()];
        for (int i = 0; i < dciList.length && it.hasNext(); ++i) {
            dciList[i] = this.getDciId(it.next());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void copyItems(boolean doMove) {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createDataCollectionOwnerSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        HashSet<AbstractObject> targets = new HashSet<AbstractObject>();
        for (AbstractObject o : dlg.getSelectedObjects()) {
            if (!(o instanceof DataCollectionTarget) && !(o instanceof Template)) continue;
            targets.add(o);
        }
        if (targets.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Target selection is invalid or empty!"));
            return;
        }
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        long[] dciList = new long[selection.size()];
        for (int i = 0; i < dciList.length && it.hasNext(); ++i) {
            dciList[i] = this.getDciId(it.next());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void openBulkUpdateDialog() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        HashSet<Long> dciList = new HashSet<Long>(selection.size());
        boolean isCustomRetention = true;
        boolean isCustomInterval = true;
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            DataCollectionObject dco = this.getDataCollectionObject(it.next());
            dciList.add(dco.getId());
            if (dco.getRetentionType() != 1) {
                isCustomRetention = false;
            }
            if (dco.getPollingScheduleType() == 1) continue;
            isCustomInterval = false;
        }
        BulkUpdateDialog dlg = new BulkUpdateDialog(this.getWindow().getShell(), isCustomRetention, isCustomInterval);
        if (dlg.open() != 0) {
            return;
        }
        List elements = dlg.getBulkUpdateElements();
        boolean changed = false;
        for (BulkDciUpdateElementUI e : elements) {
            if (!e.isModified()) continue;
            changed = true;
            break;
        }
        if (!changed) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void convertToTemplate() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createTemplateSelectionFilter());
        dlg.showFilterToolTip(false);
        if (dlg.open() != 0) {
            return;
        }
        AbstractObject[] objects = dlg.getSelectedObjects(Template.class);
        if (objects.length == 0) {
            return;
        }
        Template template = (Template)objects[0];
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        long[] dciList = new long[selection.size()];
        for (int i = 0; i < dciList.length && it.hasNext(); ++i) {
            dciList[i] = this.getDciId(it.next());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void showInformationMessage() {
        this.actionApplyChanges.setEnabled(true);
        if (!this.viewer.getTable().isDisposed() && this.messageId < 1) {
            this.messageId = this.addMessage(0, this.i18n.tr("Changes in data collection configuration will be deployed to nodes the moment when the tab is closed"), true, "Apply changes", (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void switchMode() {
        int savedSortColumn = -1;
        int savedSortDirection = 0;
        if (this.viewer != null) {
            TableColumn sortColumn = this.viewer.getTable().getSortColumn();
            int n = savedSortColumn = sortColumn != null ? (Integer)sortColumn.getData("ID") : -1;
            if (savedSortColumn >= 0) {
                savedSortColumn = this.editMode ? --savedSortColumn : ++savedSortColumn;
            }
            savedSortDirection = this.viewer.getTable().getSortDirection();
            this.viewer.getControl().dispose();
            this.session.removeListener(this.clientListener);
            if (this.dciConfig != null) {
                this.dciConfig.setRemoteChangeListener(null);
                this.dciConfig.setUserData(null);
            }
        }
        31 validator = new /* Unavailable Anonymous Inner Class!! */;
        if (this.editMode) {
            this.createDataCollectionViewer(this.parent);
            if (this.dciConfig != null) {
                this.dciConfig.setUserData((Object)this.viewer);
                this.dciConfig.setRemoteChangeListener(this.changeListener);
            }
        } else {
            this.createLastValuesViewer(this.parent, (VisibilityValidator)validator);
        }
        if (savedSortColumn != -1 && savedSortColumn < (this.editMode ? 2 : 3) && savedSortDirection != 0) {
            this.viewer.getTable().setSortColumn(this.viewer.getColumnById(savedSortColumn));
            this.viewer.getTable().setSortDirection(savedSortDirection);
        } else {
            this.viewer.getTable().setSortColumn(this.viewer.getColumnById(1));
            this.viewer.getTable().setSortDirection(1024);
        }
        this.parent.layout(true, true);
        this.updateToolBar();
        this.updateMenu();
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof DataCollectionTarget || context instanceof Template);
    }

    protected void onObjectChange(AbstractObject object) {
        if (!this.editMode && object instanceof Template) {
            this.editMode = true;
            this.switchMode();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreateItem);
        if (this.getObject() instanceof Template || this.getObject() instanceof Cluster) {
            manager.add((IAction)this.actionApplyChanges);
        }
        super.fillLocalToolBar(manager);
        if (this.editMode) {
            manager.add((IAction)this.actionHideTemplateItems);
        }
        if (!(this.getObject() instanceof Template)) {
            manager.add((IAction)this.actionToggleEditMode);
        }
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreateItem);
        manager.add((IContributionItem)new Separator());
        if (this.getObject() instanceof Template || this.getObject() instanceof Cluster) {
            manager.add((IAction)this.actionApplyChanges);
            manager.add((IContributionItem)new Separator());
        }
        super.fillLocalMenu(manager);
        if (this.editMode) {
            manager.add((IAction)this.actionHideTemplateItems);
        }
        if (!(this.getObject() instanceof Template)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionToggleEditMode);
        }
    }

    public void deactivate() {
        this.commitDciChanges(true);
        super.deactivate();
    }

    public void dispose() {
        if (this.dciConfig != null) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        super.dispose();
    }

    private void commitDciChanges(boolean ignoreErrors) {
        if (this.dciConfig == null) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setInput(DataCollectionObject[] items) {
        this.viewer.setInput((Object)items);
    }

    public void update(DataCollectionObject object) {
        this.viewer.update((Object)object, null);
    }

    private void setHideTemplateItems(boolean hide) {
        this.dcFilter.setHideTemplateItems(hide);
        this.viewer.refresh(false);
    }

    public void selectDci(long dciId) {
        this.refresh((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ NXCSession access$000(DataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(DataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$200(DataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$400(DataCollectionView x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$500(DataCollectionView x0) {
        return x0.session;
    }
}

