/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.Threshold;

public class DataCollectionItem
extends DataCollectionObject {
    public static final int DCF_DETECT_ANOMALIES = 1;
    public static final int DCF_ALL_THRESHOLDS = 2;
    public static final int DCF_RAW_VALUE_OCTET_STRING = 4;
    public static final int DCF_SHOW_ON_OBJECT_TOOLTIP = 8;
    public static final int DCF_AGGREGATE_FUNCTION_MASK = 112;
    public static final int DCF_CALCULATE_NODE_STATUS = 1024;
    public static final int DCF_SHOW_IN_OBJECT_OVERVIEW = 2048;
    public static final int DCF_MULTIPLIERS_MASK = 196608;
    public static final int DCF_STORE_CHANGES_ONLY = 262144;
    public static final int DCF_FUNCTION_SUM = 0;
    public static final int DCF_FUNCTION_AVG = 1;
    public static final int DCF_FUNCTION_MIN = 2;
    public static final int DCF_FUNCTION_MAX = 3;
    public static final int DELTA_NONE = 0;
    public static final int DELTA_SIMPLE = 1;
    public static final int DELTA_AVERAGE_PER_SECOND = 2;
    public static final int DELTA_AVERAGE_PER_MINUTE = 3;
    public static final int SNMP_RAWTYPE_NONE = 0;
    public static final int SNMP_RAWTYPE_INT32 = 1;
    public static final int SNMP_RAWTYPE_UINT32 = 2;
    public static final int SNMP_RAWTYPE_INT64 = 3;
    public static final int SNMP_RAWTYPE_UINT64 = 4;
    public static final int SNMP_RAWTYPE_DOUBLE = 5;
    public static final int SNMP_RAWTYPE_IP_ADDR = 6;
    public static final int SNMP_RAWTYPE_MAC_ADDR = 7;
    private DataType dataType;
    private int deltaCalculation;
    private int sampleCount;
    private int multiplier;
    private String unitName;
    private int snmpRawValueType;
    private ArrayList<Threshold> thresholds;
    private String predictionEngine;

    public DataCollectionItem(DataCollectionConfiguration owner, NXCPMessage msg) {
        super(owner, msg);
        this.dataType = DataType.getByValue(msg.getFieldAsInt16(47L));
        this.deltaCalculation = msg.getFieldAsInt32(105L);
        this.sampleCount = msg.getFieldAsInt32(440L);
        this.multiplier = msg.getFieldAsInt32(323L);
        this.unitName = msg.getFieldAsString(324L);
        this.snmpRawValueType = msg.getFieldAsInt32(249L);
        this.predictionEngine = msg.getFieldAsString(103L);
        int count = msg.getFieldAsInt32(54L);
        this.thresholds = new ArrayList(count);
        long varId = 0x20000000L;
        int i = 0;
        while (i < count) {
            this.thresholds.add(new Threshold(msg, varId));
            ++i;
            varId += 20L;
        }
    }

    protected DataCollectionItem(DataCollectionConfiguration owner, long nodeId, long id) {
        super(owner, nodeId, id);
        this.dataType = DataType.INT32;
        this.deltaCalculation = 0;
        this.sampleCount = 0;
        this.multiplier = 0;
        this.unitName = null;
        this.snmpRawValueType = 0;
        this.predictionEngine = "";
        this.thresholds = new ArrayList(0);
    }

    public DataCollectionItem(DataCollectionConfiguration owner, long id) {
        this(owner, owner.getOwnerId(), id);
    }

    public DataCollectionItem(long nodeId, long id) {
        this(null, nodeId, id);
    }

    protected DataCollectionItem() {
        this(null, 0L, 0L);
    }

    protected DataCollectionItem(DataCollectionConfiguration owner, DataCollectionItem src) {
        super(owner, src);
        this.dataType = src.dataType;
        this.deltaCalculation = src.deltaCalculation;
        this.sampleCount = src.sampleCount;
        this.multiplier = src.multiplier;
        this.unitName = src.unitName;
        this.snmpRawValueType = src.snmpRawValueType;
        this.thresholds = new ArrayList<Threshold>(src.thresholds);
        this.predictionEngine = src.predictionEngine;
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setFieldInt16(411L, 1);
        msg.setFieldInt16(47L, this.dataType.getValue());
        msg.setFieldInt16(105L, this.deltaCalculation);
        msg.setFieldInt16(440L, this.sampleCount);
        msg.setFieldInt16(249L, this.snmpRawValueType);
        msg.setField(103L, this.predictionEngine);
        msg.setFieldInt32(323L, this.multiplier);
        if (this.unitName != null) {
            msg.setField(324L, this.unitName);
        }
        msg.setFieldInt32(54L, this.thresholds.size());
        long varId = 0x20000000L;
        int i = 0;
        while (i < this.thresholds.size()) {
            this.thresholds.get(i).fillMessage(msg, varId);
            ++i;
            varId += 10L;
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getDeltaCalculation() {
        return this.deltaCalculation;
    }

    public void setDeltaCalculation(int deltaCalculation) {
        this.deltaCalculation = deltaCalculation;
    }

    public boolean isProcessAllThresholds() {
        return (this.flags & 2) != 0;
    }

    public void setProcessAllThresholds(boolean processAllThresholds) {
        this.flags = processAllThresholds ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean isSnmpRawValueInOctetString() {
        return (this.flags & 4) != 0;
    }

    public void setSnmpRawValueInOctetString(boolean enable) {
        this.flags = enable ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isShowOnObjectTooltip() {
        return (this.flags & 8) != 0;
    }

    public void setShowOnObjectTooltip(boolean show) {
        this.flags = show ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isShowInObjectOverview() {
        return (this.flags & 0x800) != 0;
    }

    public void setShowInObjectOverview(boolean show) {
        this.flags = show ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    public int getAggregationFunction() {
        return (this.flags & 0x70) >> 4;
    }

    public void setAggregationFunction(int func) {
        this.flags = this.flags & 0xFFFFFF8F | (func & 7) << 4;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public ArrayList<Threshold> getThresholds() {
        return this.thresholds;
    }

    public int getSnmpRawValueType() {
        return this.snmpRawValueType;
    }

    public void setSnmpRawValueType(int snmpRawValueType) {
        this.snmpRawValueType = snmpRawValueType;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public boolean isUsedForNodeStatusCalculation() {
        return (this.flags & 0x400) != 0;
    }

    public void setUsedForNodeStatusCalculation(boolean enable) {
        this.flags = enable ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public boolean isAnomalyDetectionEnabled() {
        return (this.flags & 1) != 0;
    }

    public void setAnomalyDetectionEnabled(boolean enable) {
        this.flags = enable ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public String getPredictionEngine() {
        return this.predictionEngine;
    }

    public void setPredictionEngine(String predictionEngine) {
        this.predictionEngine = predictionEngine;
    }

    public int getMultipliersSelection() {
        return (this.flags & 0x30000) >> 16;
    }

    public void setMultiplierSelection(int mode) {
        this.flags = this.flags & 0xFFFCFFFF | (mode & 3) << 16;
    }

    public boolean isStoreChangesOnly() {
        return (this.flags & 0x40000) != 0;
    }

    public void setStoreChangesOnly(boolean storeChangesOnly) {
        this.flags = storeChangesOnly ? (this.flags |= 0x40000) : (this.flags &= 0xFFFBFFFF);
    }
}

