/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AMDataType {
    STRING(0),
    INTEGER(1),
    NUMBER(2),
    BOOLEAN(3),
    ENUM(4),
    MAC_ADDRESS(5),
    IP_ADDRESS(6),
    UUID(7),
    OBJECT_REFERENCE(8),
    DATE(9);

    private static Logger logger;
    private static Map<Integer, AMDataType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(AMDataType.class);
        lookupTable = new HashMap<Integer, AMDataType>();
        AMDataType[] aMDataTypeArray = AMDataType.values();
        int n = aMDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AMDataType element = aMDataTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AMDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AMDataType getByValue(int value) {
        AMDataType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return STRING;
        }
        return element;
    }
}

