/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.InputField;
import org.netxms.client.objects.queries.ObjectQuery;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.dialogs.InputFieldEditDialog;
import org.netxms.ui.eclipse.objectbrowser.dialogs.helpers.InputFieldLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ObjectQueryEditDialog
extends Dialog {
    private ObjectQuery query;
    private List<InputField> inputFields = new ArrayList<InputField>();
    private LabeledText name;
    private LabeledText description;
    private TableViewer inputFieldsViewer;
    private Button buttonUp;
    private Button buttonDown;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private ScriptEditor source;

    public ObjectQueryEditDialog(Shell parentShell, ObjectQuery query) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.query = query;
        if (query != null) {
            this.inputFields.addAll(query.getInputFields());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.query != null ? "Edit Object Query" : "Create Object Query");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.query != null ? this.query.getName() : "");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = 300;
        this.name.setLayoutData((Object)gd);
        Composite sourceGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 2;
        sourceGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        sourceGroup.setLayoutData((Object)gd);
        new Label(sourceGroup, 0).setText("Source");
        this.source = new ScriptEditor(sourceGroup, 2048, 770, true, "Columns can be defined as global variables or as \"with\" statement variables.\r\n\r\nVariables:\r\n\t$INPUT\t\tmap with all input values where array elements are indexed by field name like: $INPUT[\"Field1\"];\r\n\tAll object attributes are available without dereference, so e.g. $node->primaryHostName can be referred just as primaryHostName\r\n\r\nReturn value: true if currently filtered object should be included in resulting set");
        this.source.setText(this.query != null ? this.query.getSource() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 600;
        gd.heightHint = 500;
        this.source.setLayoutData((Object)gd);
        this.description = new LabeledText(dialogArea, 0, 2114);
        this.description.setLabel("Description");
        this.description.setText(this.query != null ? this.query.getDescription() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.heightHint = 140;
        this.description.setLayoutData((Object)gd);
        Group inputFieldsGroup = new Group(dialogArea, 0);
        inputFieldsGroup.setText("Input Fields");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        inputFieldsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 4;
        inputFieldsGroup.setLayout((Layout)layout);
        this.inputFieldsViewer = new TableViewer((Composite)inputFieldsGroup, 67586);
        this.setupInputFieldsViewer();
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.inputFieldsViewer.getControl().setLayoutData((Object)gd);
        Composite buttonsLeft = new Composite((Composite)inputFieldsGroup, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gd);
        this.buttonUp = new Button(buttonsLeft, 8);
        this.buttonUp.setText("&Up");
        this.buttonUp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectQueryEditDialog.this.moveInputFieldUp();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonUp.setLayoutData((Object)rd);
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(buttonsLeft, 8);
        this.buttonDown.setText("&Down");
        this.buttonDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectQueryEditDialog.this.moveInputFieldDown();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonDown.setLayoutData((Object)rd);
        this.buttonDown.setEnabled(false);
        Composite buttonsRight = new Composite((Composite)inputFieldsGroup, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonsRight, 8);
        this.buttonAdd.setText("&Add...");
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectQueryEditDialog.this.addField();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttonsRight, 8);
        this.buttonEdit.setText("&Edit...");
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectQueryEditDialog.this.editInputField();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(buttonsRight, 8);
        this.buttonRemove.setText("&Remove");
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ObjectQueryEditDialog.this.removeInputField();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        return dialogArea;
    }

    private void setupInputFieldsViewer() {
        TableColumn column = new TableColumn(this.inputFieldsViewer.getTable(), 16384);
        column.setText("Name");
        column.setWidth(200);
        column = new TableColumn(this.inputFieldsViewer.getTable(), 16384);
        column.setText("Type");
        column.setWidth(90);
        column = new TableColumn(this.inputFieldsViewer.getTable(), 16384);
        column.setText("Display name");
        column.setWidth(200);
        this.inputFieldsViewer.getTable().setHeaderVisible(true);
        WidgetHelper.restoreColumnSettings((Table)this.inputFieldsViewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ObjectQueryInputFields");
        this.inputFieldsViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)ObjectQueryEditDialog.this.inputFieldsViewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ObjectQueryInputFields");
            }
        });
        this.inputFieldsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.inputFieldsViewer.setLabelProvider((IBaseLabelProvider)new InputFieldLabelProvider());
        this.inputFieldsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((InputField)e1).getSequence() - ((InputField)e2).getSequence();
            }
        });
        this.inputFieldsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = ObjectQueryEditDialog.this.inputFieldsViewer.getStructuredSelection();
                ObjectQueryEditDialog.this.buttonEdit.setEnabled(selection.size() == 1);
                ObjectQueryEditDialog.this.buttonRemove.setEnabled(selection.size() > 0);
                ObjectQueryEditDialog.this.buttonUp.setEnabled(selection.size() == 1);
                ObjectQueryEditDialog.this.buttonDown.setEnabled(selection.size() == 1);
            }
        });
        this.inputFieldsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectQueryEditDialog.this.editInputField();
            }
        });
        this.inputFieldsViewer.setInput((Object)this.inputFields.toArray());
    }

    private void addField() {
        InputField f = new InputField("Field" + Integer.toString(this.inputFields.size() + 1));
        InputFieldEditDialog dlg = new InputFieldEditDialog(this.getShell(), true, f);
        if (dlg.open() == 0 && this.inputFieldNameIsUnique(f.getName())) {
            f.setSequence(this.inputFields.size());
            this.inputFields.add(f);
            this.inputFieldsViewer.setInput((Object)this.inputFields.toArray());
            this.inputFieldsViewer.setSelection((ISelection)new StructuredSelection((Object)f));
        }
    }

    private boolean inputFieldNameIsUnique(String name) {
        for (InputField f : this.inputFields) {
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    private void editInputField() {
        IStructuredSelection selection = (IStructuredSelection)this.inputFieldsViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputFieldEditDialog dlg = new InputFieldEditDialog(this.getShell(), false, (InputField)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.inputFieldsViewer.update(selection.getFirstElement(), null);
        }
    }

    private void removeInputField() {
        IStructuredSelection selection = this.inputFieldsViewer.getStructuredSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.inputFields.remove(it.next());
        }
        this.inputFieldsViewer.setInput((Object)this.inputFields.toArray());
    }

    private void moveInputFieldUp() {
        IStructuredSelection selection = (IStructuredSelection)this.inputFieldsViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputField f = (InputField)selection.getFirstElement();
        if (f.getSequence() > 0) {
            this.updateInputFieldSequence(f.getSequence() - 1, 1);
            f.setSequence(f.getSequence() - 1);
            this.inputFieldsViewer.refresh();
        }
    }

    private void moveInputFieldDown() {
        IStructuredSelection selection = (IStructuredSelection)this.inputFieldsViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        InputField f = (InputField)selection.getFirstElement();
        if (f.getSequence() < this.inputFields.size() - 1) {
            this.updateInputFieldSequence(f.getSequence() + 1, -1);
            f.setSequence(f.getSequence() + 1);
            this.inputFieldsViewer.refresh();
        }
    }

    private void updateInputFieldSequence(int curr, int delta) {
        for (InputField f : this.inputFields) {
            if (f.getSequence() != curr) continue;
            f.setSequence(curr + delta);
            break;
        }
    }

    protected void okPressed() {
        if (this.query == null) {
            this.query = new ObjectQuery(this.name.getText().trim(), this.description.getText().trim(), this.source.getText());
        } else {
            this.query.setName(this.name.getText().trim());
            this.query.setDescription(this.description.getText().trim());
            this.query.setSource(this.source.getText());
        }
        this.query.setInputFileds(this.inputFields);
        super.okPressed();
    }

    public ObjectQuery getQuery() {
        return this.query;
    }
}

