/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.views;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.queries.ObjectQuery;
import org.netxms.client.objects.queries.ObjectQueryResult;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.tools.views.ObjectFinder;
import org.netxms.nxmc.modules.tools.views.helpers.ObjectSearchResultComparator;
import org.netxms.nxmc.modules.tools.views.helpers.ObjectSearchResultLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.ComparatorHelper;
import org.netxms.nxmc.tools.IntermediateSelectionProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.RefreshTimer;
import org.netxms.nxmc.tools.SelectionTransformation;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectFinder
extends View {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectFinder.class);
    public static final int COL_ID = 0;
    public static final int COL_CLASS = 1;
    public static final int COL_NAME = 2;
    public static final int COL_IP_ADDRESS = 3;
    public static final int COL_PARENT = 4;
    public static final int COL_ZONE = 5;
    private static final int SEARCH_MODE_NORMAL = 0;
    private static final int SEARCH_MODE_PATTERN = 1;
    private static final int SEARCH_MODE_REGEXP = 2;
    private static final String[] OBJECT_ATTRIBUTES = new String[]{"adminState", "agentVersion", "alarms", "alias", "bootTime", "bridgeBaseAddress", "bridgePortNumber", "city", "comments", "components", "country", "customAttributes", "description", "dot1xBackendAuthState", "dot1xPaeAuthState", "driver", "expectedState", "flags", "geolocation", "guid", "id", "ifIndex", "ifType", "ipAddr", "ipAddressList", "ipNetMask", "isAgent", "isBridge", "isCDP", "isExcludedFromTopology", "isLLDP", "isLocalManagement", "isLoopback", "isManuallyCreated", "isPAE", "isPhysicalPort", "isPrinter", "isRouter", "isSMCLP", "isSNMP", "isSONMP", "isSTP", "macAddr", "mapImage", "mtu", "name", "node", "nodes", "operState", "peerInterface", "peerNode", "platformName", "port", "postcode", "proxyNode", "proxyNodeId", "responsibleUsers", "runtimeFlags", "snmpOID", "snmpSysContact", "snmpSysLocation", "snmpSysName", "snmpVersion", "slot", "speed", "status", "streetAddress", "sysDescription", "type", "uin", "zone", "zoneUIN"};
    private static final String[] OBJECT_CONSTANTS = new String[]{"ACCESSPOINT", "AGENTPOLICY", "AGENTPOLICY_CONFIG", "AGENTPOLICY_LOGPARSER", "BUSINESSSERVICE", "BUSINESSSERVICEROOT", "CHASSIS", "COLLECTOR", "CLUSTER", "CONDITION", "CONTAINER", "DASHBOARD", "DASHBOARDGROUP", "DASHBOARDROOT", "INTERFACE", "MOBILEDEVICE", "NETWORK", "NETWORKMAP", "NETWORKMAPGROUP", "NETWORKMAPROOT", "NETWORKSERVICE", "NODE", "POLICYGROUP", "POLICYROOT", "RACK", "SENSOR", "SERVICEROOT", "SLMCHECK", "SUBNET", "TEMPLATE", "TEMPLATEGROUP", "TEMPLATEROOT", "VPNCONNECTOR", "ZONE"};
    private static final List<ObjectClass> OBJECT_CLASSES = new ArrayList();
    private NXCSession session = Registry.getSession();
    private SessionListener sessionListener;
    private SortableTableViewer results;
    private CTabFolder tabFolder;
    private LabeledText text;
    private Button radioPlainText;
    private Button radioPattern;
    private Button radioRegularExpression;
    private CheckboxTableViewer classList;
    private CheckboxTableViewer zoneList;
    private Text ipRangeStart;
    private Text ipRangeEnd;
    private ScriptEditor queryEditor;
    private boolean queryModified = false;
    private TableViewer queryList;
    private Composite queryHeader;
    private ProgressBar queryProgress;
    private Label queryStats;
    private Button searchButtonQuery;
    private Action actionStartSearch;
    private Action actionGoToObject;
    private Action actionSaveAs;
    private Action actionExportToCSV;
    private Action actionExportAllToCSV;
    private IntermediateSelectionProvider resultSelectionProvider;
    private List<ObjectQueryResult> searchResult = new ArrayList();

    public ObjectFinder() {
        super(LocalizationHelper.getI18n(ObjectFinder.class).tr("Find Object"), ResourceManager.getImageDescriptor((String)"icons/tool-views/find.png"), "tools.object-finder", false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        ObjectFinder view = (ObjectFinder)origin;
        this.text.setText(view.text.getText());
        this.radioPlainText.setSelection(view.radioPlainText.getSelection());
        this.radioPattern.setSelection(view.radioPattern.getSelection());
        this.radioRegularExpression.setSelection(view.radioRegularExpression.getSelection());
        this.classList.setCheckedElements(view.classList.getCheckedElements());
        Object[] zoneElements = view.zoneList.getCheckedElements();
        for (Object element : this.zoneList.getCheckedElements()) {
            int i;
            for (i = 0; i < zoneElements.length && ((Zone)element).getUIN() != ((Zone)zoneElements[i]).getUIN(); ++i) {
            }
            if (i != zoneElements.length) continue;
            this.zoneList.setChecked(element, false);
        }
        this.ipRangeStart.setText(view.ipRangeStart.getText());
        this.ipRangeEnd.setText(view.ipRangeEnd.getText());
        this.queryEditor.setText(view.queryEditor.getText());
        if (!view.searchResult.isEmpty()) {
            this.updateResultTable(view.searchResult);
        } else {
            this.results.setInput(view.results.getInput());
        }
    }

    protected void createContent(Composite parent) {
        SashForm splitter = new SashForm(parent, 512);
        Composite searchArea = new Composite((Composite)splitter, 0);
        searchArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        searchArea.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(searchArea, 0x800082);
        WidgetHelper.disableTabFolderSelectionBar((CTabFolder)this.tabFolder);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem filterTab = new CTabItem(this.tabFolder, 0);
        filterTab.setText("Filter");
        filterTab.setImage(SharedIcons.IMG_FILTER);
        Composite conditionGroup = new Composite((Composite)this.tabFolder, 0);
        layout = new GridLayout();
        layout.numColumns = this.session.isZoningEnabled() ? 3 : 2;
        conditionGroup.setLayout((Layout)layout);
        filterTab.setControl((Control)conditionGroup);
        Composite fullTextSearchGroup = new Composite(conditionGroup, 0);
        fullTextSearchGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        fullTextSearchGroup.setLayout((Layout)layout);
        this.text = new LabeledText(fullTextSearchGroup, 0);
        this.text.setLabel("Search string");
        this.text.setLayoutData((Object)new GridData(4, 128, true, false));
        1 traverseListener = new /* Unavailable Anonymous Inner Class!! */;
        this.text.addTraverseListener((TraverseListener)traverseListener);
        Group searchModeGroup = new Group(fullTextSearchGroup, 0);
        searchModeGroup.setText("Search mode");
        layout = new GridLayout();
        searchModeGroup.setLayout((Layout)layout);
        this.radioPlainText = new Button((Composite)searchModeGroup, 16);
        this.radioPlainText.setText("&Normal");
        this.radioPlainText.setSelection(true);
        this.radioPattern = new Button((Composite)searchModeGroup, 16);
        this.radioPattern.setText("&Pattern (* = any string, ? = any character)");
        this.radioRegularExpression = new Button((Composite)searchModeGroup, 16);
        this.radioRegularExpression.setText("&Regular expression");
        Composite classFilterGroup = new Composite(conditionGroup, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        classFilterGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        classFilterGroup.setLayout((Layout)layout);
        Label classFilterTitle = new Label(classFilterGroup, 0);
        classFilterTitle.setText("Class filter");
        this.classList = CheckboxTableViewer.newCheckList((Composite)classFilterGroup, (int)2080);
        this.classList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.classList.setInput((Object)OBJECT_CLASSES);
        this.classList.setAllChecked(true);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        this.classList.getTable().setLayoutData((Object)gd);
        Composite classListButtons = new Composite(classFilterGroup, 0);
        RowLayout rlayout = new RowLayout();
        rlayout.marginLeft = 0;
        classListButtons.setLayout((Layout)rlayout);
        Button selectAll = new Button(classListButtons, 8);
        selectAll.setText("Select &all");
        RowData rd = new RowData();
        rd.width = 90;
        selectAll.setLayoutData((Object)rd);
        selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button clearAll = new Button(classListButtons, 8);
        clearAll.setText("&Clear all");
        rd = new RowData();
        rd.width = 90;
        clearAll.setLayoutData((Object)rd);
        clearAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.session.isZoningEnabled()) {
            Composite zoneFilterGroup = new Composite(conditionGroup, 0);
            gd = new GridData(4, 4, true, true);
            gd.verticalSpan = 2;
            zoneFilterGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            zoneFilterGroup.setLayout((Layout)layout);
            Label zoneFilterTitle = new Label(zoneFilterGroup, 0);
            zoneFilterTitle.setText("Zone filter");
            this.zoneList = CheckboxTableViewer.newCheckList((Composite)zoneFilterGroup, (int)2080);
            this.zoneList.setContentProvider((IContentProvider)new ArrayContentProvider());
            List zones = this.session.getAllZones();
            this.zoneList.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
            this.zoneList.setInput((Object)zones);
            this.zoneList.setAllChecked(true);
            gd = new GridData(4, 4, true, true);
            gd.heightHint = 100;
            this.zoneList.getTable().setLayoutData((Object)gd);
            Composite zoneListButtons = new Composite(zoneFilterGroup, 0);
            rlayout = new RowLayout();
            rlayout.marginLeft = 0;
            zoneListButtons.setLayout((Layout)rlayout);
            selectAll = new Button(zoneListButtons, 8);
            selectAll.setText("Select &all");
            rd = new RowData();
            rd.width = 90;
            selectAll.setLayoutData((Object)rd);
            selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            clearAll = new Button(zoneListButtons, 8);
            clearAll.setText("&Clear all");
            rd = new RowData();
            rd.width = 90;
            clearAll.setLayoutData((Object)rd);
            clearAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        Group ipFilterGroup = new Group(conditionGroup, 0);
        ipFilterGroup.setText("IP Range");
        ipFilterGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        layout = new GridLayout();
        layout.numColumns = 3;
        ipFilterGroup.setLayout((Layout)layout);
        this.ipRangeStart = new Text((Composite)ipFilterGroup, 2048);
        this.ipRangeStart.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipRangeStart.addTraverseListener((TraverseListener)traverseListener);
        new Label((Composite)ipFilterGroup, 0).setText(" - ");
        this.ipRangeEnd = new Text((Composite)ipFilterGroup, 2048);
        this.ipRangeEnd.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipRangeEnd.addTraverseListener((TraverseListener)traverseListener);
        Button searchButtonFilter = new Button(conditionGroup, 8);
        searchButtonFilter.setText("&Search");
        gd = new GridData(16384, 1024, true, false);
        gd.widthHint = 90;
        searchButtonFilter.setLayoutData((Object)gd);
        searchButtonFilter.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        CTabItem queryTab = new CTabItem(this.tabFolder, 0);
        queryTab.setText("Query");
        queryTab.setImage(SharedIcons.IMG_FIND);
        Composite queryArea = new Composite((Composite)this.tabFolder, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 4;
        queryArea.setLayout((Layout)layout);
        queryTab.setControl((Control)queryArea);
        Label labelQueryEditor = new Label(queryArea, 16384);
        labelQueryEditor.setText("Query");
        gd = new GridData(4, 1024, true, false);
        gd.horizontalSpan = 2;
        labelQueryEditor.setLayoutData((Object)gd);
        Label labelQueryList = new Label(queryArea, 16384);
        labelQueryList.setText("Saved queries");
        labelQueryList.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.queryEditor = new ScriptEditor(queryArea, 2048, 770, true);
        this.queryEditor.addVariables(Arrays.asList(OBJECT_ATTRIBUTES));
        this.queryEditor.addConstants(Arrays.asList(OBJECT_CONSTANTS));
        this.queryEditor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.queryEditor.setLayoutData((Object)gd);
        this.queryList = new TableViewer(queryArea, 67584);
        this.queryList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.queryList.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.queryList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.queryList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.queryList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.loadQueries();
        RefreshTimer queryListRefreshTimer = new RefreshTimer(500, this.queryList.getControl(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.queryHeader = new Composite(queryArea, 0);
        GridLayout queryHeaderLayout = new GridLayout();
        queryHeaderLayout.numColumns = 3;
        queryHeaderLayout.marginWidth = 0;
        queryHeaderLayout.marginHeight = 0;
        queryHeaderLayout.marginTop = 5;
        this.queryHeader.setLayout((Layout)queryHeaderLayout);
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.queryHeader.setLayoutData((Object)gd);
        this.searchButtonQuery = new Button(this.queryHeader, 8);
        this.searchButtonQuery.setText("&Search");
        gd = new GridData(16384, 1024, false, false);
        gd.widthHint = 90;
        this.searchButtonQuery.setLayoutData((Object)gd);
        this.searchButtonQuery.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.queryStats = new Label(this.queryHeader, 0);
        gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalIndent = 10;
        this.queryStats.setLayoutData((Object)gd);
        this.queryStats.setText(this.i18n.tr("Idle"));
        Label separator = new Label(searchArea, 258);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        separator.setLayoutData((Object)gd);
        Composite resultArea = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resultArea.setLayout((Layout)layout);
        PreferenceStore settings = PreferenceStore.getInstance();
        int[] weights = new int[]{settings.getAsInteger("ObjectFinder.weight1", 25), settings.getAsInteger("ObjectFinder.weight2", 70)};
        splitter.setWeights(weights);
        separator = new Label(resultArea, 258);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        separator.setLayoutData((Object)gd);
        String[] names = new String[]{"ID", "Class", "Name", "IP Address", "Parent", "Zone"};
        int[] widths = new int[]{90, 120, 300, 250, 300, 200};
        this.results = new SortableTableViewer(resultArea, names, widths, 0, 128, 65538);
        if (!this.session.isZoningEnabled()) {
            this.results.removeColumnById(5);
        }
        this.results.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.results.setLabelProvider((IBaseLabelProvider)new ObjectSearchResultLabelProvider((TableViewer)this.results));
        this.results.setComparator((ViewerComparator)new ObjectSearchResultComparator());
        this.results.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.results, (String)"ResultTable");
        parent.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.resultSelectionProvider = new IntermediateSelectionProvider((ISelectionProvider)this.results, (SelectionTransformation)new /* Unavailable Anonymous Inner Class!! */);
        this.createResultsContextMenu();
        this.createActions();
        this.tabFolder.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tabFolder.setSelection(settings.getAsInteger("ObjectFinder.selectedTab", 0));
    }

    private void createActions() {
        this.actionStartSearch = new /* Unavailable Anonymous Inner Class!! */;
        this.actionStartSearch.setId("org.netxms.ui.eclipse.objectbrowser.actions.startSearch");
        this.actionStartSearch.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.start_search");
        this.addKeyBinding("F9", (IAction)this.actionStartSearch);
        this.actionGoToObject = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSaveAs = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCSV = new ExportToCsvAction((View)this, (ColumnViewer)this.results, true);
        this.actionExportAllToCSV = new ExportToCsvAction((View)this, (ColumnViewer)this.results, false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionStartSearch);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCSV);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionStartSearch);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCSV);
    }

    private void createResultsContextMenu() {
        20 objectMenuManager = new /* Unavailable Anonymous Inner Class!! */;
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.results.getControl());
        this.results.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager, MenuManager nodeMenuManager) {
        manager.add((IAction)this.actionExportToCSV);
        manager.add((IAction)this.actionExportAllToCSV);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionGoToObject);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)nodeMenuManager);
    }

    public void setFocus() {
        switch (this.tabFolder.getSelectionIndex()) {
            case 0: {
                this.text.setFocus();
                break;
            }
            case 1: {
                this.queryEditor.setFocus();
            }
        }
    }

    public void refresh() {
        this.loadQueries();
    }

    private void startQuery() {
        this.queryStats.setText("0%");
        this.queryProgress = new ProgressBar(this.queryStats.getParent(), 65792);
        this.queryProgress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.queryProgress.setMinimum(0);
        this.queryProgress.setMaximum(100);
        this.queryHeader.layout(true, true);
        this.searchButtonQuery.setEnabled(false);
        this.actionStartSearch.setEnabled(false);
        long startTime = System.currentTimeMillis();
        String query = this.queryEditor.getText();
        22 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void startSearch() {
        InetAddress addrStart = null;
        InetAddress addrEnd = null;
        if (!this.ipRangeStart.getText().trim().isEmpty() && !this.ipRangeEnd.getText().trim().isEmpty()) {
            try {
                addrStart = InetAddress.getByName(this.ipRangeStart.getText().trim());
            }
            catch (UnknownHostException e) {
                MessageDialogHelper.openWarning((Shell)this.getWindow().getShell(), (String)"Warning", (String)"IP address range start is invalid");
            }
            try {
                addrEnd = InetAddress.getByName(this.ipRangeEnd.getText().trim());
            }
            catch (UnknownHostException e) {
                MessageDialogHelper.openWarning((Shell)this.getWindow().getShell(), (String)"Warning", (String)"IP address range end is invalid");
            }
        }
        ArrayList<Integer> classFilter = new ArrayList<Integer>();
        for (Object o : this.classList.getCheckedElements()) {
            classFilter.add(((ObjectClass)o).classId);
        }
        ArrayList<Integer> zoneFilter = new ArrayList<Integer>();
        if (this.session.isZoningEnabled()) {
            for (Object o : this.zoneList.getCheckedElements()) {
                zoneFilter.add(((Zone)o).getUIN());
            }
        }
        if (this.radioRegularExpression.getSelection()) {
            this.doSearch(this.text.getText().trim(), 2, classFilter, zoneFilter, addrStart, addrEnd);
        } else {
            this.doSearch(this.text.getText().trim().toLowerCase(), this.radioPattern.getSelection() ? 1 : 0, classFilter, zoneFilter, addrStart, addrEnd);
        }
    }

    private void doSearch(String searchString, int mode, List<Integer> classFilter, List<Integer> zoneFilter, InetAddress addrStart, InetAddress addrEnd) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private static boolean checkAddrRange(InetAddress start, InetAddress end, AbstractObject object) {
        ArrayList<InetAddressEx> addrList = new ArrayList<InetAddressEx>(16);
        if (object instanceof AbstractNode) {
            addrList.add(((AbstractNode)object).getPrimaryIP());
            for (AbstractObject o : object.getAllChildren(3)) {
                addrList.addAll(((Interface)o).getIpAddressList());
            }
        } else if (object instanceof Interface) {
            addrList.addAll(((Interface)object).getIpAddressList());
        } else if (object instanceof AccessPoint) {
            addrList.add(((AccessPoint)object).getIpAddress());
        }
        for (InetAddressEx a : addrList) {
            if (ComparatorHelper.compareInetAddresses((InetAddress)a.getAddress(), (InetAddress)start) < 0 || ComparatorHelper.compareInetAddresses((InetAddress)a.getAddress(), (InetAddress)end) > 0) continue;
            return true;
        }
        return false;
    }

    private void goToObject() {
        IStructuredSelection selection = this.results.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Object selectedElement = selection.getFirstElement();
        AbstractObject object = selectedElement instanceof ObjectQueryResult ? ((ObjectQueryResult)selectedElement).getObject() : (AbstractObject)selectedElement;
        MainWindow.switchToObject((long)object.getObjectId(), (long)0L);
    }

    private void resetResultTable() {
        int i;
        TableColumn[] columns = this.results.getTable().getColumns();
        int n = i = this.session.isZoningEnabled() ? 6 : 5;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
    }

    private void updateResultTable(List<ObjectQueryResult> objects) {
        this.resetResultTable();
        this.searchResult = objects;
        HashSet<String> registeredProperties = new HashSet<String>();
        for (ObjectQueryResult r : objects) {
            for (String n : r.getPropertyNames()) {
                if (registeredProperties.contains(n)) continue;
                TableColumn tc = this.results.addColumn(n, 200);
                tc.setData("propertyName", (Object)n);
                registeredProperties.add(n);
            }
        }
        this.results.setInput(objects);
    }

    private void saveQuery() {
        if (this.tabFolder.getSelectionIndex() != 1) {
            return;
        }
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), "Save Object Query", "Query name", "", (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        ObjectQuery query = new ObjectQuery(dlg.getValue(), "", this.queryEditor.getText());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void loadQueries() {
        26 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    static {
        OBJECT_CLASSES.add(new ObjectClass(33, "Access Point"));
        OBJECT_CLASSES.add(new ObjectClass(28, "Business Service"));
        OBJECT_CLASSES.add(new ObjectClass(27, "Business Service Root"));
        OBJECT_CLASSES.add(new ObjectClass(35, "Chassis"));
        OBJECT_CLASSES.add(new ObjectClass(14, "Cluster"));
        OBJECT_CLASSES.add(new ObjectClass(13, "Condition"));
        OBJECT_CLASSES.add(new ObjectClass(29, "Collector"));
        OBJECT_CLASSES.add(new ObjectClass(5, "Container"));
        OBJECT_CLASSES.add(new ObjectClass(23, "Dashboard"));
        OBJECT_CLASSES.add(new ObjectClass(22, "Dashboard Root"));
        OBJECT_CLASSES.add(new ObjectClass(3, "Interface"));
        OBJECT_CLASSES.add(new ObjectClass(31, "Mobile Device"));
        OBJECT_CLASSES.add(new ObjectClass(4, "Network"));
        OBJECT_CLASSES.add(new ObjectClass(21, "Network Map"));
        OBJECT_CLASSES.add(new ObjectClass(20, "Network Map Group"));
        OBJECT_CLASSES.add(new ObjectClass(19, "Network Map Root"));
        OBJECT_CLASSES.add(new ObjectClass(11, "Network Service"));
        OBJECT_CLASSES.add(new ObjectClass(2, "Node"));
        OBJECT_CLASSES.add(new ObjectClass(32, "Rack"));
        OBJECT_CLASSES.add(new ObjectClass(37, "Sensor"));
        OBJECT_CLASSES.add(new ObjectClass(7, "Service Root"));
        OBJECT_CLASSES.add(new ObjectClass(1, "Subnet"));
        OBJECT_CLASSES.add(new ObjectClass(8, "Template"));
        OBJECT_CLASSES.add(new ObjectClass(9, "Template Group"));
        OBJECT_CLASSES.add(new ObjectClass(10, "Template Root"));
        OBJECT_CLASSES.add(new ObjectClass(12, "VPN Connector"));
        OBJECT_CLASSES.add(new ObjectClass(6, "Zone"));
    }
}

