/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.WirelessStationComparator;
import org.netxms.nxmc.modules.objects.views.helpers.WirelessStationFilter;
import org.netxms.nxmc.modules.objects.views.helpers.WirelessStationLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class WirelessStations
extends NodeSubObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(WirelessStations.class);
    public static final int COLUMN_MAC_ADDRESS = 0;
    public static final int COLUMN_VENDOR = 1;
    public static final int COLUMN_IP_ADDRESS = 2;
    public static final int COLUMN_NODE_NAME = 3;
    public static final int COLUMN_ACCESS_POINT = 4;
    public static final int COLUMN_RADIO = 5;
    public static final int COLUMN_SSID = 6;
    private SortableTableViewer viewer;
    private Action actionCopyRecord;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public WirelessStations() {
        super("Wireless Stations", ResourceManager.getImageDescriptor((String)"icons/object-views/wireless-stations.png"), "objects.wireless-stations", true);
    }

    public int getPriority() {
        return 55;
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof AbstractNode && (((AbstractNode)context).isWirelessAccessPoint() || ((AbstractNode)context).isWirelessController()) || context instanceof AccessPoint);
    }

    public void createContent(Composite parent) {
        super.createContent(parent);
        String[] names = new String[]{this.i18n.tr("MAC Address"), this.i18n.tr("NIC Vendor"), this.i18n.tr("IP Address"), this.i18n.tr("Node"), this.i18n.tr("Access Point"), this.i18n.tr("Radio"), "SSID"};
        int[] widths = new int[]{120, 200, 100, 180, 180, 100, 100};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WirelessStationLabelProvider((TableViewer)this.viewer));
        this.viewer.setComparator((ViewerComparator)new WirelessStationComparator());
        WirelessStationFilter filter = new WirelessStationFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"WirelessStations");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        this.actionCopyRecord = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRecord);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    protected void onObjectChange(AbstractObject object) {
        if (this.isActive()) {
            this.refresh();
        }
    }

    public void activate() {
        super.activate();
        this.refresh();
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return false;
    }

    public void refresh() {
        long objectId = this.getObjectId();
        if (objectId == 0L) {
            return;
        }
        this.clearMessages();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void copyToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    for (int j = 0; j < this.viewer.getTable().getColumnCount(); ++j) {
                        if (j > 0) {
                            sb.append('\t');
                        }
                        sb.append(selection[i].getText(j));
                    }
                    continue;
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }
}

