/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectView;
import org.netxms.nxmc.modules.objects.widgets.PortViewWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;

public class PortView
extends NodeSubObjectView
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private PortViewWidget portView;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    public PortView() {
        super(LocalizationHelper.getI18n(PortView.class).tr("Ports"), ResourceManager.getImageDescriptor((String)"icons/object-views/ports.png"), "objects.ports", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).isBridge();
    }

    public int getPriority() {
        return 90;
    }

    protected void onObjectChange(AbstractObject object) {
        this.portView.setNodeId(object != null ? object.getObjectId() : 0L);
        this.scroller.setMinSize(this.portView.computeSize(-1, -1));
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.scroller = new ScrolledComposite(this.mainArea, 768);
        this.portView = new PortViewWidget((Composite)this.scroller, 0);
        this.portView.addSelectionListener((PortSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setBackground(this.portView.getBackground());
        this.scroller.setContent((Control)this.portView);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createContextMenu();
    }

    public void refresh() {
        this.portView.setNodeId(this.getObjectId());
        this.scroller.setMinSize(this.portView.computeSize(-1, -1));
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface && object.isDirectChildOf(this.getObjectId());
    }

    private void createContextMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this, null);
        this.portView.setMenu(menuMgr.createContextMenu((Control)this.portView));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

