/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodesView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.NodeListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.NodeListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NodesView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(NodesView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_IP_ADDRESS = 2;
    public static final int COLUMN_RACK = 3;
    public static final int COLUMN_PLATFORM = 4;
    public static final int COLUMN_AGENT_VERSION = 5;
    public static final int COLUMN_SYS_DESCRIPTION = 6;
    public static final int COLUMN_STATUS = 7;
    private SortableTableViewer viewer;
    private Action actionExportToCsv;
    private SessionListener sessionListener;

    public NodesView() {
        super(LocalizationHelper.getI18n(NodesView.class).tr("Nodes"), ResourceManager.getImageDescriptor((String)"icons/object-views/nodes.png"), "objects.nodes", false);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    public boolean isValidForContext(Object context) {
        return context instanceof Subnet || context instanceof Cluster || context instanceof Collector || context instanceof Container || context instanceof ServiceRoot || context instanceof Rack;
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Primary IP"), this.i18n.tr("Rack"), this.i18n.tr("Platform"), this.i18n.tr("Agent Version"), this.i18n.tr("Sys Description"), this.i18n.tr("Status")};
        int[] widths = new int[]{60, 150, 100, 150, 150, 100, 300, 100};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setLabelProvider((IBaseLabelProvider)new NodeListLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new NodeListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"NodeTable.V2");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
    }

    private void createContextMenu() {
        3 menuMgr = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        if (this.getObject() != null) {
            ArrayList<AbstractObject> list = new ArrayList<AbstractObject>();
            for (AbstractObject o : this.getObject().getAllChildren(2)) {
                list.add(o);
            }
            this.viewer.setInput((Object)list.toArray());
        } else {
            this.viewer.setInput((Object)new AbstractNode[0]);
        }
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.refresh();
        }
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void activate() {
        this.refresh();
        super.activate();
    }
}

