/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Condition;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.StatusSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class ConditionEvents
extends ObjectPropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(ConditionEvents.class);
    private Condition condition;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private ObjectSelector sourceObject;
    private StatusSelector activeStatus;
    private StatusSelector inactiveStatus;

    public ConditionEvents(AbstractObject object) {
        super(LocalizationHelper.getI18n(ConditionEvents.class).tr("Events and Status"), object);
    }

    public String getId() {
        return "conditionEvents";
    }

    public int getPriority() {
        return 10;
    }

    public boolean isVisible() {
        return this.object instanceof Condition;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.condition = (Condition)this.object;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Group eventGroup = new Group(dialogArea, 0);
        eventGroup.setText(this.i18n.tr("Events"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        eventGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        eventGroup.setLayout((Layout)layout);
        this.activationEvent = new EventSelector((Composite)eventGroup, 0);
        this.activationEvent.setLabel(this.i18n.tr("Activation event"));
        this.activationEvent.setEventCode((long)this.condition.getActivationEvent());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.activationEvent.setLayoutData((Object)gd);
        this.deactivationEvent = new EventSelector((Composite)eventGroup, 0);
        this.deactivationEvent.setLabel(this.i18n.tr("Deactivation event"));
        this.deactivationEvent.setEventCode((long)this.condition.getDeactivationEvent());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.deactivationEvent.setLayoutData((Object)gd);
        this.sourceObject = new ObjectSelector((Composite)eventGroup, 0, true);
        this.sourceObject.setLabel(this.i18n.tr("Source object for events"));
        this.sourceObject.setEmptySelectionName(this.i18n.tr("<server>"));
        this.sourceObject.setObjectId(this.condition.getEventSourceObject());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.sourceObject.setLayoutData((Object)gd);
        Group statusGroup = new Group(dialogArea, 0);
        statusGroup.setText(this.i18n.tr("Status"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        statusGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        statusGroup.setLayout((Layout)layout);
        this.activeStatus = new StatusSelector((Composite)statusGroup, 0, Severity.CRITICAL.getValue());
        this.activeStatus.setLabel(this.i18n.tr("Active status"));
        this.activeStatus.setSelection(this.condition.getActiveStatus());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.activeStatus.setLayoutData((Object)gd);
        this.inactiveStatus = new StatusSelector((Composite)statusGroup, 0, Severity.CRITICAL.getValue());
        this.inactiveStatus.setLabel(this.i18n.tr("Inactive status"));
        this.inactiveStatus.setSelection(this.condition.getInactiveStatus());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.inactiveStatus.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.condition.getObjectId());
        md.setActivationEvent((int)this.activationEvent.getEventCode());
        md.setDeactivationEvent((int)this.deactivationEvent.getEventCode());
        md.setSourceObject(this.sourceObject.getObjectId());
        md.setActiveStatus(this.activeStatus.getSelection());
        md.setInactiveStatus(this.inactiveStatus.getSelection());
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

