/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ObjectFilter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AssetGroup;
import org.netxms.client.objects.AssetRoot;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Collector;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectCreateMenuManager;
import org.xnap.commons.i18n.I18n;

public class ObjectCreateMenuManager
extends MenuManager {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectCreateMenuManager.class);
    private Shell shell;
    private View view;
    private AbstractObject parent;
    private long parentId;
    private Action actionCreateAsset;
    private Action actionCreateAssetGroup;
    private Action actionCreateBusinessService;
    private Action actionCreateBusinessServicePrototype;
    private Action actionCreateChassis;
    private Action actionCreateCollector;
    private Action actionCreateCluster;
    private Action actionCreateCondition;
    private Action actionCreateContainer;
    private Action actionCreateDashboard;
    private Action actionCreateDashboardGroup;
    private Action actionCreateInterface;
    private Action actionCreateNetworkService;
    private Action actionCreateMobileDevice;
    private Action actionCreateNetworkMap;
    private Action actionCreateNetworkMapGroup;
    private Action actionCreateNode;
    private Action actionCreateRack;
    private Action actionCreateSensor;
    private Action actionCreateSubnet;
    private Action actionCreateTemplate;
    private Action actionCreateTemplateGroup;
    private Action actionCreateVpnConnector;
    private Action actionCreateWirelessDomain;
    private Action actionCreateZone;

    public ObjectCreateMenuManager(Shell shell, View view, AbstractObject parent) {
        this.shell = shell;
        this.view = view;
        this.parent = parent;
        this.parentId = parent.getObjectId();
        this.setMenuText(this.i18n.tr("&Create"));
        this.createActions();
        this.addAction((IMenuManager)this, this.actionCreateAsset, o -> o instanceof AssetGroup || o instanceof AssetRoot);
        this.addAction((IMenuManager)this, this.actionCreateAssetGroup, o -> o instanceof AssetGroup || o instanceof AssetRoot);
        this.addAction((IMenuManager)this, this.actionCreateBusinessService, o -> o instanceof BusinessService || o instanceof BusinessServiceRoot && !(o instanceof BusinessServicePrototype));
        this.addAction((IMenuManager)this, this.actionCreateBusinessServicePrototype, o -> o instanceof BusinessService || o instanceof BusinessServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateChassis, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateCluster, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateCondition, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateCollector, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateContainer, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateDashboard, o -> o instanceof DashboardGroup || o instanceof DashboardRoot);
        this.addAction((IMenuManager)this, this.actionCreateDashboardGroup, o -> o instanceof DashboardGroup || o instanceof DashboardRoot);
        this.addAction((IMenuManager)this, this.actionCreateInterface, o -> o instanceof Node);
        this.addAction((IMenuManager)this, this.actionCreateNetworkService, o -> o instanceof Node);
        this.addAction((IMenuManager)this, this.actionCreateMobileDevice, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateNetworkMap, o -> o instanceof NetworkMapGroup || o instanceof NetworkMapRoot);
        this.addAction((IMenuManager)this, this.actionCreateNetworkMapGroup, o -> o instanceof NetworkMapGroup || o instanceof NetworkMapRoot);
        this.addAction((IMenuManager)this, this.actionCreateNode, o -> o instanceof Cluster || o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateRack, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateSensor, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateSubnet, o -> o instanceof Zone || o instanceof EntireNetwork && !Registry.getSession().isZoningEnabled());
        this.addAction((IMenuManager)this, this.actionCreateTemplate, o -> o instanceof TemplateGroup || o instanceof TemplateRoot);
        this.addAction((IMenuManager)this, this.actionCreateTemplateGroup, o -> o instanceof TemplateGroup || o instanceof TemplateRoot);
        this.addAction((IMenuManager)this, this.actionCreateVpnConnector, o -> o instanceof Node);
        this.addAction((IMenuManager)this, this.actionCreateWirelessDomain, o -> o instanceof Container || o instanceof Collector || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateZone, o -> o instanceof EntireNetwork && Registry.getSession().isZoningEnabled());
    }

    protected void createActions() {
        this.actionCreateAsset = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateAssetGroup = new GenericObjectCreationAction(this, this.i18n.tr("Asset &group..."), 17, this.i18n.tr("Asset Group"));
        this.actionCreateBusinessService = new GenericObjectCreationAction(this, this.i18n.tr("&Business service..."), 28, this.i18n.tr("Business Service"));
        this.actionCreateBusinessServicePrototype = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateChassis = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateCluster = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateCondition = new GenericObjectCreationAction(this, this.i18n.tr("C&ondition..."), 13, this.i18n.tr("Condition"));
        this.actionCreateCollector = new GenericObjectCreationAction(this, this.i18n.tr("&Collector..."), 29, this.i18n.tr("Collector"));
        this.actionCreateContainer = new GenericObjectCreationAction(this, this.i18n.tr("&Container..."), 5, this.i18n.tr("Container"));
        this.actionCreateDashboard = new GenericObjectCreationAction(this, this.i18n.tr("&Dashboard..."), 23, this.i18n.tr("Dashboard"));
        this.actionCreateDashboardGroup = new GenericObjectCreationAction(this, this.i18n.tr("Dashboard &group..."), 36, this.i18n.tr("Dashboard Group"));
        this.actionCreateInterface = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateNetworkService = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateMobileDevice = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateNetworkMap = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateNetworkMapGroup = new GenericObjectCreationAction(this, this.i18n.tr("Network map &group..."), 20, this.i18n.tr("Network Map Group"));
        this.actionCreateNode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateRack = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateSensor = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateSubnet = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateTemplate = new GenericObjectCreationAction(this, this.i18n.tr("&Template..."), 8, this.i18n.tr("Template"));
        this.actionCreateTemplateGroup = new GenericObjectCreationAction(this, this.i18n.tr("Template &group..."), 9, this.i18n.tr("Template Group"));
        this.actionCreateVpnConnector = new GenericObjectCreationAction(this, this.i18n.tr("&VPN connector..."), 12, this.i18n.tr("VPN Connector"));
        this.actionCreateWirelessDomain = new GenericObjectCreationAction(this, this.i18n.tr("&Wireless domain..."), 34, this.i18n.tr("Wireless Domain"));
        this.actionCreateZone = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void addAction(IMenuManager manager, Action action, ObjectFilter filter) {
        if (filter.accept(this.parent)) {
            manager.add((IAction)action);
        }
    }

    private static MessageAreaHolder getMessageArea(View view) {
        return view != null && view.getPerspective() != null ? view.getPerspective().getMessageArea() : null;
    }
}

