/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.custom.CGraphNode;
import org.eclipse.gef4.zest.core.widgets.zooming.ZoomManager;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.base.GeoLocation;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.DecorationLayerAbstractFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ExtendedGraphViewer;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.FigureChangeCallback;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapContentProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.MapLabelProvider;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ObjectFigure;
import org.netxms.nxmc.modules.networkmaps.widgets.helpers.ZoomAction;
import org.netxms.nxmc.modules.worldmap.tools.MapLoader;
import org.netxms.nxmc.modules.worldmap.tools.TileSet;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ColorCache;
import org.xnap.commons.i18n.I18n;

public class ExtendedGraphViewer
extends GraphViewer {
    public static final double[] zoomLevels = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0};
    private I18n i18n = LocalizationHelper.getI18n(ExtendedGraphViewer.class);
    private View view;
    private FigureChangeCallback moveCallback;
    private ExtendedSWTEventDispatcher eventDispatcher;
    private BackgroundFigure backgroundFigure;
    private Image backgroundImage = null;
    private TileSet backgroundTiles = null;
    private GeoLocation backgroundLocation = null;
    private int backgroundZoom;
    private MapLoader mapLoader;
    private Layer backgroundLayer;
    private Layer decorationLayer;
    private Layer indicatorLayer;
    private Layer controlLayer;
    private int crosshairX;
    private int crosshairY;
    private Crosshair crosshairFigure;
    private GridFigure gridFigure;
    private int gridSize = 96;
    private boolean snapToGrid = false;
    private MouseListener snapToGridListener;
    private List<NetworkMapElement> mapDecorations;
    private Set<NetworkMapElement> selectedDecorations = new HashSet();
    private Map<Long, DecorationLayerAbstractFigure> decorationFigures = new HashMap();
    private ColorCache colors;
    private Image iconBack;
    private OverlayButton backButton = null;
    private boolean draggingEnabled = true;
    private boolean centeredBackground = false;
    private boolean fitBackground = false;
    private boolean dragStarted = false;
    private int blockRefresh;
    private org.eclipse.swt.graphics.Point rightClickLocation = null;

    public ExtendedGraphViewer(Composite composite, int style, View view, FigureChangeCallback moveCallback) {
        super(composite, style | 0x40);
        this.view = view;
        this.moveCallback = moveCallback;
        this.eventDispatcher = new ExtendedSWTEventDispatcher();
        this.graph.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
        this.colors = new ColorCache((Control)this.graph);
        ScalableFigure rootLayer = this.graph.getRootLayer();
        this.iconBack = ResourceManager.getImage((String)"icons/netmap/back.png");
        this.mapLoader = new MapLoader(composite.getDisplay());
        this.graph.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.backgroundLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.backgroundLayer, null, 0);
        this.backgroundFigure = new BackgroundFigure(this);
        this.backgroundFigure.setSize(10, 10);
        this.backgroundLayer.add((IFigure)this.backgroundFigure);
        this.decorationLayer = new FreeformLayer();
        this.decorationLayer.setOpaque(false);
        rootLayer.add((IFigure)this.decorationLayer, null, 1);
        this.indicatorLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.indicatorLayer, null, 2);
        this.controlLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.controlLayer, null);
        this.getZoomManager().setZoomLevels(zoomLevels);
        this.graph.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        3 backgroundMouseListener = new /* Unavailable Anonymous Inner Class!! */;
        this.graph.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)backgroundMouseListener);
        this.graph.getZestRootLayer().addMouseListener((MouseListener)backgroundMouseListener);
        this.snapToGridListener = new /* Unavailable Anonymous Inner Class!! */;
        if (moveCallback != null) {
            5 moveMouseListener = new /* Unavailable Anonymous Inner Class!! */;
            6 moveMouseMoutionListener = new /* Unavailable Anonymous Inner Class!! */;
            this.graph.getZestRootLayer().addMouseListener((MouseListener)moveMouseListener);
            this.graph.getZestRootLayer().addMouseMotionListener((MouseMotionListener)moveMouseMoutionListener);
        }
    }

    public void blockRefresh() {
        ++this.blockRefresh;
    }

    public void unblockRefresh() {
        --this.blockRefresh;
    }

    public void updateDecorationFigure(NetworkMapElement d) {
        DecorationLayerAbstractFigure figure = (DecorationLayerAbstractFigure)this.decorationFigures.get(d.getId());
        if (figure != null) {
            figure.refresh();
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        boolean dynamicLayoutEnabled = this.graph.isDynamicLayoutEnabled();
        this.graph.setDynamicLayout(false);
        super.inputChanged(input, oldInput);
        this.graph.setDynamicLayout(dynamicLayoutEnabled);
        this.decorationLayer.removeAll();
        this.decorationFigures.clear();
        if (this.getContentProvider() instanceof MapContentProvider && this.getLabelProvider() instanceof MapLabelProvider) {
            this.mapDecorations = ((MapContentProvider)this.getContentProvider()).getDecorations(input);
            if (this.mapDecorations != null) {
                MapLabelProvider lp = (MapLabelProvider)this.getLabelProvider();
                for (NetworkMapElement d : this.mapDecorations) {
                    DecorationLayerAbstractFigure figure = (DecorationLayerAbstractFigure)lp.getFigure((Object)d);
                    figure.setLocation(new Point(d.getX(), d.getY()));
                    this.decorationLayer.add((IFigure)figure);
                    this.decorationFigures.put(d.getId(), figure);
                }
            }
        }
    }

    protected void setDecorationSelection(NetworkMapElement d, boolean addToExisting) {
        if (!addToExisting) {
            this.clearDecorationSelection(false);
            this.graph.setSelection(null);
        }
        this.selectedDecorations.add(d);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
        this.firePostSelectionChanged(event);
    }

    private void clearDecorationSelection(boolean sendEvent) {
        if (this.selectedDecorations.size() == 0) {
            return;
        }
        for (NetworkMapElement d : this.selectedDecorations) {
            DecorationLayerAbstractFigure f = (DecorationLayerAbstractFigure)this.decorationFigures.get(d.getId());
            if (f == null) continue;
            f.setSelected(false);
        }
        this.selectedDecorations.clear();
        if (sendEvent) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            this.fireSelectionChanged(event);
            this.firePostSelectionChanged(event);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        this.selectedDecorations.clear();
        if (l != null) {
            this.clearDecorationSelection(false);
            for (Object o : l) {
                if (!(o instanceof NetworkMapDecoration) && !(o instanceof NetworkMapDCIContainer) && !(o instanceof NetworkMapDCIImage) && !(o instanceof NetworkMapTextBox)) continue;
                this.selectedDecorations.add((NetworkMapElement)o);
                DecorationLayerAbstractFigure f = (DecorationLayerAbstractFigure)this.decorationFigures.get(((NetworkMapElement)o).getId());
                if (f == null) continue;
                f.setSelected(true);
            }
        }
        super.setSelectionToWidget(l, reveal);
    }

    protected List getSelectionFromWidget() {
        List selection = super.getSelectionFromWidget();
        for (NetworkMapElement d : this.selectedDecorations) {
            selection.add(d);
        }
        return selection;
    }

    public void setBackgroundColor(RGB color) {
        Color c = this.colors.create(color);
        this.graph.setBackground(c);
        this.graph.getLightweightSystem().getRootFigure().setBackgroundColor(c);
    }

    public void setBackgroundImage(Image image, boolean centered, boolean fit) {
        if (this.backgroundImage == image && this.centeredBackground == centered && this.fitBackground == fit) {
            return;
        }
        this.backgroundImage = image;
        this.centeredBackground = centered;
        this.fitBackground = fit;
        this.backgroundLocation = null;
        this.backgroundTiles = null;
        this.graph.redraw();
    }

    public void setBackgroundImage(GeoLocation location, int zoom) {
        if (this.backgroundLocation != null && this.backgroundLocation.equals((Object)location) && zoom == this.backgroundZoom) {
            return;
        }
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        this.backgroundImage = null;
        this.backgroundTiles = null;
        this.centeredBackground = false;
        this.fitBackground = false;
        this.backgroundLocation = location;
        this.backgroundZoom = zoom;
        this.graph.redraw();
        this.reloadMapBackground();
    }

    private void reloadMapBackground() {
        Dimension controlSize = this.backgroundFigure.getSize();
        org.eclipse.swt.graphics.Point mapSize = new org.eclipse.swt.graphics.Point(controlSize.width, controlSize.height);
        7 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.graph);
        } else {
            this.getFactory().refresh(this.graph, element, updateLabels);
        }
    }

    public void zoomIn() {
        this.getZoomManager().zoomIn();
    }

    public void zoomOut() {
        this.getZoomManager().zoomOut();
    }

    public void zoomFit() {
        this.getZoomManager().setZoom(1.0);
        org.eclipse.swt.graphics.Rectangle visibleArea = this.getGraphControl().getClientArea();
        Rectangle mapArea = this.getGraphControl().getRootLayer().getBounds();
        double dx = (double)visibleArea.width / (double)mapArea.width;
        double dy = (double)visibleArea.height / (double)mapArea.height;
        this.getZoomManager().setZoom(Math.min(dx, dy));
    }

    public void zoomTo(double zoomLevel) {
        this.getZoomManager().setZoom(zoomLevel);
    }

    public double getZoom() {
        return this.getZoomManager().getZoom();
    }

    public Action[] createZoomActions() {
        ZoomManager zoomManager = this.getZoomManager();
        Action[] actions = new Action[zoomLevels.length];
        for (int i = 0; i < zoomLevels.length; ++i) {
            actions[i] = new ZoomAction(zoomLevels[i], zoomManager);
            if (zoomLevels[i] == this.getZoom()) {
                actions[i].setChecked(true);
            }
            if (zoomLevels[i] != 1.0 || this.view == null) continue;
            this.view.addKeyBinding("M1+0", (IAction)actions[i]);
        }
        return actions;
    }

    public void showBackButton(Runnable action) {
        if (this.backButton != null) {
            this.backButton.setAction(action);
        } else {
            this.backButton = new OverlayButton(this, this.iconBack, action);
            this.controlLayer.add((IFigure)this.backButton);
            this.backButton.setLocation(new Point(10, 10));
        }
    }

    public void hideBackButton() {
        if (this.backButton != null) {
            this.controlLayer.remove((IFigure)this.backButton);
            this.backButton = null;
        }
    }

    public void showCrosshair(int x, int y) {
        if (this.crosshairFigure == null) {
            this.crosshairFigure = new Crosshair(this);
            this.indicatorLayer.add((IFigure)this.crosshairFigure);
            this.crosshairFigure.setSize(this.graph.getRootLayer().getSize());
        }
        this.crosshairX = x;
        this.crosshairY = y;
        this.crosshairFigure.repaint();
    }

    public void hideCrosshair() {
        if (this.crosshairFigure != null) {
            this.indicatorLayer.remove((IFigure)this.crosshairFigure);
            this.crosshairFigure = null;
        }
    }

    public void showGrid(boolean show) {
        if (show) {
            if (this.gridFigure == null) {
                this.gridFigure = new GridFigure(this);
                this.backgroundLayer.add((IFigure)this.gridFigure, null, 1);
                this.gridFigure.setSize(this.backgroundFigure.getSize());
            }
        } else if (this.gridFigure != null) {
            this.backgroundLayer.remove((IFigure)this.gridFigure);
            this.gridFigure = null;
        }
    }

    public boolean isGridVisible() {
        return this.gridFigure != null;
    }

    public void alignToGrid(boolean movedOnly) {
        for (Object o : this.graph.getNodes()) {
            ObjectFigure f;
            if (!(o instanceof CGraphNode)) continue;
            CGraphNode n = (CGraphNode)o;
            if (movedOnly && (!(f = (ObjectFigure)n.getFigure()).readMovedState() || !f.isElementSelected())) continue;
            Point p = n.getLocation();
            Dimension size = n.getSize();
            int dx = p.x % this.gridSize;
            dx = dx < this.gridSize / 2 ? -dx : this.gridSize - dx;
            int dy = p.y % this.gridSize;
            dy = dy < this.gridSize / 2 ? -dy : this.gridSize - dy;
            n.setLocation((double)(p.x + (dx += (this.gridSize - size.width) / 2)), (double)(p.y + (dy += (this.gridSize - size.height) / 2)));
        }
    }

    public void setSnapToGrid(boolean snap) {
        if (snap == this.snapToGrid) {
            return;
        }
        this.snapToGrid = snap;
        if (snap) {
            this.graph.getZestRootLayer().addMouseListener(this.snapToGridListener);
        } else {
            this.graph.getZestRootLayer().removeMouseListener(this.snapToGridListener);
        }
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled;
    }

    public boolean isRefreshBlocked() {
        return this.blockRefresh > 0;
    }

    public void setDraggingEnabled(boolean draggingEnabled) {
        this.draggingEnabled = draggingEnabled;
        this.graph.setDraggingEnabled(draggingEnabled);
    }

    void resizeToolTipShell() {
        this.eventDispatcher.resizeToolTipShell();
    }

    protected IStylingGraphModelFactory getFactory() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Image takeSnapshot() {
        ScalableFigure rootLayer = this.graph.getRootLayer();
        Dimension d = rootLayer.getSize();
        Image image = new Image((Device)this.graph.getDisplay(), d.width, d.height);
        GC gc = new GC((Drawable)image);
        SWTGraphics g = new SWTGraphics(gc);
        rootLayer.paint((Graphics)g);
        g.dispose();
        gc.dispose();
        return image;
    }

    public void onLinkChange(NetworkMapLink element) {
        if (this.moveCallback != null) {
            this.moveCallback.onLinkChange(element);
        }
    }

    public void onDecorationMove(NetworkMapElement element) {
        if (this.moveCallback != null) {
            this.moveCallback.onMove(element);
        }
    }

    public void setMapSize(int width, int height) {
        this.graph.setPreferredSize(width, height);
        this.backgroundFigure.setSize(width, height);
        this.backgroundFigure.setBorder((Border)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Dimension getMapSize() {
        if (this.graph.getPreferredSize().height == -1) {
            org.eclipse.swt.graphics.Rectangle visibleArea = this.getGraphControl().getClientArea();
            return new Dimension(visibleArea.width, visibleArea.height);
        }
        return this.graph.getPreferredSize();
    }

    public int getCurrentZoomIndex() {
        for (int i = 0; i < zoomLevels.length; ++i) {
            if (!(this.getZoom() <= zoomLevels[i])) continue;
            return i;
        }
        return 0;
    }

    public org.eclipse.swt.graphics.Point getRightClickLocation() {
        return this.rightClickLocation;
    }

    public org.eclipse.swt.graphics.Point translateToRelative(org.eclipse.swt.graphics.Point location) {
        Point mousePoint = new Point(location.x, location.y);
        this.graph.getRootLayer().translateToRelative((Translatable)mousePoint);
        return new org.eclipse.swt.graphics.Point(mousePoint.x, mousePoint.y);
    }

    public int getHorizontalBarSelection() {
        return this.graph.getHorizontalBar().getSelection();
    }

    public int getVerticalBarSelection() {
        return this.graph.getVerticalBar().getSelection();
    }

    static /* synthetic */ Graph access$000(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$100(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$200(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$300(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$400(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$500(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$600(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ LayoutAlgorithm access$700(ExtendedGraphViewer x0) {
        return x0.getLayoutAlgorithm();
    }

    static /* synthetic */ Graph access$800(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$900(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$1000(ExtendedGraphViewer x0) {
        return x0.graph;
    }

    static /* synthetic */ Graph access$1100(ExtendedGraphViewer x0) {
        return x0.graph;
    }
}

