/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.AgentPolicy;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.LocalChangeListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.SavePolicyDialog;
import org.netxms.nxmc.modules.datacollection.views.PolicyEditorView;
import org.netxms.nxmc.modules.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.AgentConfigPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.FileDeliveryPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.GenericPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.LogParserPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.SupportAppPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.PolicyModifyListener;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class PolicyEditorView
extends AdHocObjectView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(PolicyEditorView.class);
    private static final Logger logger = LoggerFactory.getLogger(PolicyEditorView.class);
    private AbstractPolicyEditor editor = null;
    private NXCSession session;
    private long templateId;
    private UUID policyGUID = NXCommon.EMPTY_GUID;
    private AgentPolicy policy;
    private boolean throwExceptionOnSave;
    private Exception saveException;
    private Display display;
    private boolean modified = false;
    private boolean modifiedByOtherUser = false;
    private boolean saveInProgress = false;
    private Composite content;
    private Action actionSave;
    private LocalChangeListener localChangeListener;

    public PolicyEditorView(UUID policyGUID, long templateId, LocalChangeListener localChangeListener) {
        super(LocalizationHelper.getI18n(PolicyEditorView.class).tr("Policy Editor"), ResourceManager.getImageDescriptor((String)"icons/object-views/policy.gif"), "objects.policy-editor." + policyGUID.toString(), templateId, templateId, false);
        this.session = Registry.getSession();
        this.templateId = templateId;
        this.policyGUID = policyGUID;
        this.localChangeListener = localChangeListener;
    }

    protected PolicyEditorView() {
        super(null, null, null, 0L, 0L, false);
        this.session = Registry.getSession();
    }

    public View cloneView() {
        PolicyEditorView view = (PolicyEditorView)super.cloneView();
        view.templateId = this.templateId;
        view.policyGUID = this.policyGUID;
        view.localChangeListener = this.localChangeListener;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        PolicyEditorView origin = (PolicyEditorView)view;
        origin.editor.updatePolicyFromControl();
        this.policy = origin.policy;
        this.modified = origin.modified;
        origin.modifiedByOtherUser = false;
        this.modifiedByOtherUser = false;
        this.actionSave.setEnabled(this.modified);
        this.updateFields();
    }

    protected void createContent(Composite parent) {
        this.display = parent.getDisplay();
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FillLayout());
        this.createActions();
        this.session.addListener((SessionListener)this);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.modified = false;
        this.actionSave.setEnabled(false);
        this.refresh();
    }

    public void dispose() {
        this.modified = false;
        this.localChangeListener = null;
        super.dispose();
    }

    protected void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave.setEnabled(false);
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        if (this.editor != null) {
            this.editor.fillLocalPullDown(manager);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.editor != null) {
            this.editor.fillLocalToolBar(manager);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
    }

    public void refresh() {
        if (this.modified) {
            if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)"Refresh policy", (String)"This will discard all unsaved changes. Do you really want to continue?")) {
                return;
            }
            this.modified = false;
            this.actionSave.setEnabled(false);
        }
        this.modifiedByOtherUser = false;
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private void updateFields() {
        this.setName(this.policy.getName());
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        switch (this.policy.getPolicyType()) {
            case "AgentConfig": {
                this.editor = new AgentConfigPolicyEditor(this.content, 0, this.policy, this);
                break;
            }
            case "FileDelivery": {
                this.editor = new FileDeliveryPolicyEditor(this.content, 0, this.policy, this);
                break;
            }
            case "LogParserConfig": {
                this.editor = new LogParserPolicyEditor(this.content, 0, this.policy, this);
                break;
            }
            case "SupportApplicationConfig": {
                this.editor = new SupportAppPolicyEditor(this.content, 0, this.policy, this);
                break;
            }
            default: {
                this.editor = new GenericPolicyEditor(this.content, 0, this.policy, this);
            }
        }
        this.updateToolBar();
        this.updateMenu();
        this.editor.addModifyListener((PolicyModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.content.layout(true, true);
        this.editor.setFocus();
    }

    protected void setModified() {
        if (this.modified) {
            return;
        }
        this.modified = true;
        this.actionSave.setEnabled(true);
    }

    public void enableSaveAction(boolean enable) {
        this.actionSave.setEnabled(enable && this.modified);
    }

    public void doSave() {
        block2: {
            try {
                this.session.savePolicy(this.templateId, this.policy, false);
            }
            catch (Exception e) {
                logger.error("Exception during policy save", (Throwable)e);
                this.saveException = e;
                if (this.throwExceptionOnSave) break block2;
                MessageDialogHelper.openError((Shell)this.getWindow().getShell(), (String)"Error", (String)String.format("Cannot save policy object: %s", e.getLocalizedMessage()));
            }
        }
    }

    private void save() {
        if (this.modifiedByOtherUser && this.modified) {
            if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)"Save policy", (String)"This policy already modified by other users. Do you really want to continue and overwrite other users changes?\n")) {
                return;
            }
            this.clearMessages();
        }
        this.saveInProgress = true;
        this.modifiedByOtherUser = false;
        this.throwExceptionOnSave = true;
        this.editor.updatePolicyFromControl();
        this.editor.onSave();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.setFocus();
        }
    }

    public boolean beforeClose() {
        if (!this.modified) {
            return true;
        }
        String reason = this.editor.isSaveAllowed();
        if (reason != null) {
            MessageDialogHelper.openWarning((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Save Not Allowed"), (String)reason);
            return false;
        }
        SavePolicyDialog dlg = new SavePolicyDialog(this.getWindow().getShell());
        int rc = dlg.open();
        if (rc == 100) {
            this.save();
            return true;
        }
        if (rc == 1) {
            return false;
        }
        this.editor.onDiscard();
        return true;
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1039: {
                if (n.getSubCode() != this.templateId || !((AgentPolicy)n.getObject()).getGuid().equals(this.policyGUID)) {
                    return;
                }
                this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 1040: {
                if (n.getSubCode() != this.templateId || !this.policyGUID.equals(n.getObject())) {
                    return;
                }
                this.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }
}

