/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.util.Map;
import java.util.Set;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.DciIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.Root;

@Root(name="element", strict=false)
public abstract class AbstractChartConfig
extends DashboardElementConfig {
    @ElementArray(required=false)
    private ChartDciConfig[] dciList = new ChartDciConfig[0];
    @Element(required=false)
    private int legendPosition = 8;
    @Element(required=false)
    private boolean showLegend = true;
    @Element(required=false)
    private boolean extendedLegend = false;
    @Element(required=false)
    private boolean autoScale = true;
    @Element(required=false)
    private boolean translucent = false;
    @Element(required=false)
    private int refreshRate = 30;
    @Element(required=false)
    private double minYScaleValue = 0.0;
    @Element(required=false)
    private double maxYScaleValue = 100.0;
    @Element(required=false)
    private boolean modifyYBase = false;
    @Element(required=false)
    private long drillDownObjectId = 0L;

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        for (ChartDciConfig dci : this.dciList) {
            objects.add(dci.nodeId);
        }
        return objects;
    }

    public Map<Long, Long> getDataCollectionItems() {
        Map items = super.getDataCollectionItems();
        for (ChartDciConfig dci : this.dciList) {
            items.put(dci.dciId, dci.nodeId);
        }
        return items;
    }

    public void remapDataCollectionItems(Map<Long, DciIdMatchingData> remapData) {
        super.remapDataCollectionItems(remapData);
        for (ChartDciConfig dci : this.dciList) {
            DciIdMatchingData md = remapData.get(dci.dciId);
            if (md == null) continue;
            dci.dciId = md.dstDciId;
            dci.nodeId = md.dstNodeId;
        }
    }

    public ChartDciConfig[] getDciList() {
        return this.dciList;
    }

    public void setDciList(ChartDciConfig[] dciList) {
        this.dciList = dciList;
    }

    public int getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(int legendPosition) {
        this.legendPosition = legendPosition;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean showLegend) {
        this.showLegend = showLegend;
    }

    public boolean isExtendedLegend() {
        return this.extendedLegend;
    }

    public void setExtendedLegend(boolean extendedLegend) {
        this.extendedLegend = extendedLegend;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }

    public double getMinYScaleValue() {
        return this.minYScaleValue;
    }

    public void setMinYScaleValue(double minYScaleValue) {
        this.minYScaleValue = minYScaleValue;
    }

    public double getMaxYScaleValue() {
        return this.maxYScaleValue;
    }

    public void setMaxYScaleValue(double maxYScaleValue) {
        this.maxYScaleValue = maxYScaleValue;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public void setModifyYBase(boolean modifyYBase) {
        this.modifyYBase = modifyYBase;
    }

    public boolean modifyYBase() {
        return this.modifyYBase;
    }

    public long getDrillDownObjectId() {
        return this.drillDownObjectId;
    }

    public void setDrillDownObjectId(long drillDownObjectId) {
        this.drillDownObjectId = drillDownObjectId;
    }
}

