/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.dialogs;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.dialogs.AlarmStateChangeFailureDialog;
import org.xnap.commons.i18n.I18n;

public class AlarmStateChangeFailureDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(AlarmStateChangeFailureDialog.class);
    private SortableTableViewer alarmList;
    private Map<Long, Integer> failures;

    public AlarmStateChangeFailureDialog(Shell parentShell, Map<Long, Integer> failures) {
        super(parentShell);
        this.failures = failures;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Alarm State Change Errors"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label text = new Label(dialogArea, 0);
        text.setText(this.i18n.tr("State of some alarms was not changed due to following reasons:"));
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Reason")};
        int[] widths = new int[]{80, 250};
        this.alarmList = new SortableTableViewer(dialogArea, names, widths, 0, 128, 68098);
        this.alarmList.setContentProvider((IContentProvider)new MapContentProvider(this));
        this.alarmList.setLabelProvider((IBaseLabelProvider)new FailuresLabelProvider(this));
        this.alarmList.setInput((Object)this.failures);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 350;
        this.alarmList.getTable().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        super.okPressed();
    }
}

