/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectContextBase;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.views.HistoricalGraphView;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class GraphTemplateCache {
    private static GraphTemplateCache instance = null;
    private NXCSession session = null;
    private List<GraphDefinition> templateList = new ArrayList<GraphDefinition>();

    public GraphTemplateCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                block0 : switch (n.getCode()) {
                    case 1028: {
                        int i = 0;
                        while (i < GraphTemplateCache.this.templateList.size()) {
                            GraphDefinition o = GraphTemplateCache.this.templateList.get(i);
                            if (o.getId() == n.getSubCode()) {
                                GraphTemplateCache.this.templateList.remove(i);
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 1012: {
                        if (!(n.getObject() instanceof GraphDefinition) || !((GraphDefinition)n.getObject()).isTemplate()) break;
                        boolean objectUpdated = false;
                        int i = 0;
                        while (i < GraphTemplateCache.this.templateList.size()) {
                            if (GraphTemplateCache.this.templateList.get(i).getId() == n.getSubCode()) {
                                GraphTemplateCache.this.templateList.set(i, (GraphDefinition)n.getObject());
                                objectUpdated = true;
                                break;
                            }
                            ++i;
                        }
                        if (objectUpdated) break;
                        GraphTemplateCache.this.templateList.add((GraphDefinition)n.getObject());
                    }
                }
            }
        });
    }

    public static void attachSession(NXCSession session) {
        instance = new GraphTemplateCache(session);
    }

    public static GraphTemplateCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List<GraphDefinition> list = this.templateList;
            synchronized (list) {
                this.templateList.clear();
                this.templateList = this.session.getPredefinedGraphs(true);
            }
        }
        catch (Exception e) {
            Activator.logError("Exception in ObjectToolsCache.reload()", e);
        }
    }

    public GraphDefinition[] getGraphTemplates() {
        GraphDefinition[] graphs = this.templateList.toArray(new GraphDefinition[this.templateList.size()]);
        Arrays.sort(graphs, new Comparator<GraphDefinition>(){

            @Override
            public int compare(GraphDefinition arg0, GraphDefinition arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        return graphs;
    }

    public static void instantiate(final AbstractNode node, GraphDefinition template, DciValue[] dciList, NXCSession session, Display display) throws IOException, NXCException {
        ArrayList<String> textsToExpand = new ArrayList<String>();
        textsToExpand.add(template.getTitle());
        String name = (String)session.substituteMacros((ObjectContextBase)new ObjectContext((AbstractObject)node, null), textsToExpand, new HashMap()).get(0);
        final GraphDefinition graphDefinition = new GraphDefinition(template, name);
        final HashSet<ChartDciConfig> chartMetrics = new HashSet<ChartDciConfig>();
        ChartDciConfig[] chartDciConfigArray = graphDefinition.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            if (dci.regexMatch) {
                Pattern namePattern = Pattern.compile(dci.dciName);
                Pattern descriptionPattern = Pattern.compile(dci.dciDescription);
                int j = 0;
                while (j < dciList.length) {
                    Matcher nameMatch = namePattern.matcher(dciList[j].getName());
                    Matcher descriptionMatch = descriptionPattern.matcher(dciList[j].getDescription());
                    if (!dci.dciName.isEmpty() && nameMatch.find() || !dci.dciDescription.isEmpty() && descriptionMatch.find()) {
                        chartMetrics.add(new ChartDciConfig(dci, !dci.dciName.isEmpty() && nameMatch.find() ? nameMatch : descriptionMatch, dciList[j]));
                        if (!dci.multiMatch) break;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < dciList.length) {
                    if (!dci.dciName.isEmpty() && dciList[j].getName().equalsIgnoreCase(dci.dciName) || !dci.dciDescription.isEmpty() && dciList[j].getDescription().equalsIgnoreCase(dci.dciDescription)) {
                        chartMetrics.add(new ChartDciConfig(dci, dciList[j]));
                        if (!dci.multiMatch) break;
                    }
                    ++j;
                }
            }
            ++n2;
        }
        if (!chartMetrics.isEmpty()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    graphDefinition.setDciList(chartMetrics.toArray(new ChartDciConfig[chartMetrics.size()]));
                    GraphTemplateCache.showPredefinedGraph(graphDefinition, node.getObjectId());
                }
            });
        } else {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogHelper.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)"None of template DCI were found on a node.");
                }
            });
        }
    }

    private static void showPredefinedGraph(GraphDefinition graphDefinition, long objectId) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(graphDefinition.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            encodedName = "___ERROR___";
        }
        String id = "org.netxms.ui.eclipse.charts.predefinedGraph&" + encodedName + "&" + objectId;
        try {
            HistoricalGraphView g = (HistoricalGraphView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
            if (g != null) {
                g.initPredefinedGraph(graphDefinition);
            }
        }
        catch (PartInitException e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.PredefinedGraphTree_Error, (String)String.format(Messages.PredefinedGraphTree_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }
}

