/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.ui.eclipse.snmp.SnmpConstants;
import org.netxms.ui.eclipse.snmp.shared.MibCache;

public class SnmpValueLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private boolean shortTextualNames = false;

    public void setShortTextualNames(boolean shortTextualNames) {
        this.shortTextualNames = shortTextualNames;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SnmpValue value = (SnmpValue)element;
        switch (columnIndex) {
            case 0: {
                return value.getName();
            }
            case 1: {
                MibObject object = MibCache.findObject(value.getName(), false);
                if (object == null) {
                    return "";
                }
                return this.shortTextualNames ? object.getName() : object.getFullName();
            }
            case 2: {
                return SnmpConstants.getAsnTypeName(value.getType());
            }
            case 3: {
                return value.getValue();
            }
            case 4: {
                return SnmpValueLabelProvider.byteArraytoString(value.getRawValue());
            }
        }
        return null;
    }

    private static String byteArraytoString(byte[] bytes) {
        if (bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int ub = bytes[0] & 0xFF;
        if (ub < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(ub));
        int i = 1;
        while (i < bytes.length) {
            sb.append(' ');
            ub = bytes[i] & 0xFF;
            if (ub < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(ub));
            ++i;
        }
        return sb.toString().toUpperCase();
    }
}

